/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Urls;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class HttpFileSystemBase
extends HttpFileSystem {
    private final String myProtocol;

    public HttpFileSystemBase(String protocol) {
        this.myProtocol = protocol;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "findFileByPath"));
        }
        return this.findFileByPath(path, false);
    }

    public VirtualFile findFileByPath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "findFileByPath"));
        }
        try {
            return HttpFileSystemBase.getRemoteFileManager().getOrCreateFile(Urls.newFromIdea(VirtualFileManager.constructUrl((String)this.myProtocol, (String)path)), path, isDirectory);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "addFileListener"));
        }
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "addFileListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "addFileListener"));
        }
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener, parentDisposable);
    }

    public void removeFileListener(@NotNull HttpVirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "removeFileListener"));
        }
        HttpFileSystemBase.getRemoteFileManager().removeFileListener(listener);
    }

    public boolean isFileDownloaded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "isFileDownloaded"));
        }
        return file instanceof HttpVirtualFile && ((HttpVirtualFile)file).getFileInfo().getState() == RemoteFileState.DOWNLOADED;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildDirectory"));
        }
        throw new UnsupportedOperationException();
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildFile"));
        }
        throw new UnsupportedOperationException();
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "deleteFile"));
        }
        throw new UnsupportedOperationException();
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "moveFile"));
        }
        throw new UnsupportedOperationException();
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "copyFile"));
        }
        throw new UnsupportedOperationException();
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "renameFile"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "extractPresentableUrl"));
        }
        String string = VirtualFileManager.constructUrl((String)this.myProtocol, (String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "extractPresentableUrl"));
        }
        return string;
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @NotNull
    public String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "getProtocol"));
        }
        return string;
    }

    private static RemoteFileManagerImpl getRemoteFileManager() {
        return (RemoteFileManagerImpl)RemoteFileManager.getInstance();
    }
}

