/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.PlatformIcons;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.ContinuationFinalTasksInserter;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.NotNull;

public class TestContinuationAction
extends AnAction {
    public TestContinuationAction() {
        super("Test Continuation", "Test Continuation", PlatformIcons.ADVICE_ICON);
    }

    public void actionPerformed(final AnActionEvent e) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Test Continuation", true, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return false;
            }

            public void processSentToBackground() {
            }
        }){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/update/TestContinuationAction$2", "run"));
                }
                Continuation continuation = Continuation.createForCurrentProgress(project, true, e.getPresentation().getText());
                ReportTask finalBlock = new ReportTask("I'm finally block!");
                finalBlock.setHaveMagicCure(true);
                continuation.run(new LongTaskDescriptor("First"), new ReportTask("First complete"), new TaskDescriptor("Adding task", Where.POOLED){

                    public void run(ContinuationContext context) {
                        TestContinuationAction.this.addMore(context);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }, new LongTaskDescriptor("Second"), new ReportTask("Second complete"), new TaskDescriptor("Adding task 2", Where.POOLED){

                    public void run(ContinuationContext context) {
                        TestContinuationAction.this.addMoreSurviving(context);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        throw new IllegalStateException();
                    }
                }, new LongTaskDescriptor("Third"), new ReportTask("Third complete"), finalBlock);
            }

            public void onCancel() {
                Messages.showInfoMessage((String)"cancel!", (String)this.myTitle);
            }

            public void onSuccess() {
                Messages.showInfoMessage((String)"success!", (String)this.myTitle);
            }
        });
    }

    private void addMore(ContinuationContext context) {
        context.next(new TaskDescriptor[]{new LongTaskDescriptor("Inside killable"), new ReportTask("Inside killable complete")});
    }

    private void addMoreSurviving(ContinuationContext context) {
        ContinuationFinalTasksInserter finalTasksInserter = new ContinuationFinalTasksInserter(context);
        finalTasksInserter.allNextAreFinal();
        context.next(new TaskDescriptor[]{new LongTaskDescriptor("Inside surviving"), new ReportTask("Inside surviving complete")});
        finalTasksInserter.removeFinalPropertyAdder();
    }

    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        e.getPresentation().setEnabled(project != null);
    }

    private static class LongTaskDescriptor
    extends TaskDescriptor {
        private LongTaskDescriptor(String name) {
            super(name, Where.POOLED);
        }

        public void run(ContinuationContext context) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            pi.setText(this.getName());
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            pi.setText("");
        }
    }

    private static class ReportTask
    extends TaskDescriptor {
        private ReportTask(String name) {
            super(name, Where.AWT);
        }

        public void run(ContinuationContext context) {
            Messages.showInfoMessage((String)this.getName(), (String)"Result");
        }
    }
}

