/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffUIContext;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(this.isVisible(dc) && this.isEnabled(dc));
    }

    private boolean isVisible(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        return project != null && VcsDataKeys.LABEL_BEFORE.getData(dc) != null && VcsDataKeys.LABEL_AFTER.getData(dc) != null;
    }

    private boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        if (!this.isVisible(dc) || !this.isEnabled(dc)) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        Label before = (Label)VcsDataKeys.LABEL_BEFORE.getData(dc);
        Label after = (Label)VcsDataKeys.LABEL_AFTER.getData(dc);
        String selectedUrl = (String)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        ShowDiffAction.showDiffForChange(new MyIterableWrapper(iterable.iterator(), before, after), new MySelectionMarker(selectedUrl), project, new ShowDiffUIContext(true));
    }

    private static class MyIteratorWrapper
    implements Iterator<Change> {
        private final MyLoader myBeforeLoader;
        private final MyLoader myAfterLoader;
        private final Iterator<Pair<VirtualFilePointer, FileStatus>> myVfIterator;

        public MyIteratorWrapper(Iterator<Pair<VirtualFilePointer, FileStatus>> vfIterator, Label before, Label after) {
            this.myVfIterator = vfIterator;
            this.myBeforeLoader = new MyLoader(before);
            this.myAfterLoader = new MyLoader(after);
        }

        @Override
        public boolean hasNext() {
            return this.myVfIterator.hasNext();
        }

        @Override
        public Change next() {
            Pair<VirtualFilePointer, FileStatus> pair = this.myVfIterator.next();
            VirtualFilePointer pointer = (VirtualFilePointer)pair.getFirst();
            MyCheckpointContentRevision before = new MyCheckpointContentRevision(pointer, this.myBeforeLoader, true);
            MyCheckpointContentRevision after = new MyCheckpointContentRevision(pointer, this.myAfterLoader, false);
            if (FileStatus.ADDED.equals(pair.getSecond())) {
                before = null;
            } else if (FileStatus.DELETED.equals(pair.getSecond())) {
                after = null;
            }
            return new Change((ContentRevision)before, (ContentRevision)after, (FileStatus)pair.getSecond());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MyCheckpointContentRevision
    implements ContentRevision {
        private java.lang.ref.SoftReference<String> myContent;
        private final MyLoader myLoader;
        private final VirtualFilePointer myPointer;
        private final boolean myBefore;

        private MyCheckpointContentRevision(VirtualFilePointer pointer, MyLoader loader, boolean before) {
            this.myLoader = loader;
            this.myPointer = pointer;
            this.myBefore = before;
        }

        public String getContent() throws VcsException {
            String s = (String)SoftReference.dereference(this.myContent);
            if (s != null) {
                return s;
            }
            String loaded = this.myLoader.convert(this.myPointer);
            this.myContent = new java.lang.ref.SoftReference<String>(loaded);
            return loaded;
        }

        public String getUrl() {
            return this.myPointer.getUrl();
        }

        @NotNull
        public FilePath getFile() {
            VirtualFile vf = this.myPointer.getFile();
            if (vf != null) {
                FilePathImpl filePathImpl = new FilePathImpl(vf);
                if (filePathImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyCheckpointContentRevision", "getFile"));
                }
                return filePathImpl;
            }
            FilePathImpl filePathImpl = new FilePathImpl(new File(this.myPointer.getPresentableUrl()), false);
            if (filePathImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyCheckpointContentRevision", "getFile"));
            }
            return filePathImpl;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = new VcsRevisionNumber(){

                public String asString() {
                    return MyCheckpointContentRevision.this.myBefore ? "Before update" : "After update";
                }

                public int compareTo(VcsRevisionNumber o) {
                    return MyCheckpointContentRevision.this.myBefore ? -1 : 1;
                }
            };
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyCheckpointContentRevision", "getRevisionNumber"));
            }
            return vcsRevisionNumber;
        }
    }

    private static class MyLoader {
        private final Label myLabel;

        private MyLoader(Label label) {
            this.myLabel = label;
        }

        @Nullable
        public String convert(VirtualFilePointer pointer) {
            if (pointer == null) {
                return null;
            }
            String path = pointer.getPresentableUrl();
            ByteContent byteContent = this.myLabel.getByteContent(FileUtil.toSystemIndependentName((String)path));
            if (byteContent == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
                return null;
            }
            VirtualFile vf = pointer.getFile();
            if (vf == null) {
                return ((Object)LoadTextUtil.getTextByBinaryPresentation(byteContent.getBytes(), EncodingManager.getInstance().getDefaultCharset())).toString();
            }
            return ((Object)LoadTextUtil.getTextByBinaryPresentation(byteContent.getBytes(), vf)).toString();
        }
    }

    private static class MyIterableWrapper
    implements Iterable<Change> {
        private final Iterator<Pair<VirtualFilePointer, FileStatus>> myVfIterator;
        private final Label myBefore;
        private final Label myAfter;

        private MyIterableWrapper(Iterator<Pair<VirtualFilePointer, FileStatus>> vfIterator, Label before, Label after) {
            this.myVfIterator = vfIterator;
            this.myBefore = before;
            this.myAfter = after;
        }

        @Override
        public Iterator<Change> iterator() {
            return new MyIteratorWrapper(this.myVfIterator, this.myBefore, this.myAfter);
        }
    }

    private static class MySelectionMarker
    implements Condition<Change> {
        private final String mySelectedPath;
        private boolean myFirstSelected;

        public MySelectionMarker(String selectedPath) {
            this.mySelectedPath = selectedPath;
        }

        public boolean value(Change change) {
            if (this.mySelectedPath == null) {
                if (this.myFirstSelected) {
                    this.myFirstSelected = true;
                    return true;
                }
                return false;
            }
            MyCheckpointContentRevision revision = (MyCheckpointContentRevision)(change.getBeforeRevision() == null ? change.getAfterRevision() : change.getBeforeRevision());
            String url = revision.getUrl();
            return this.mySelectedPath.equals(url);
        }
    }
}

