/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import java.util.Iterator;
import java.util.List;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final Project myProject;
    private final LineStatusTrackerManagerI myLineStatusTrackerManagerI;

    public UpToDateLineNumberProviderImpl(Document document, Project project) {
        this.myDocument = document;
        this.myProject = project;
        this.myLineStatusTrackerManagerI = LineStatusTrackerManager.getInstance(this.myProject);
    }

    public int getLineNumber(int currentNumber) {
        LineStatusTracker tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            return currentNumber;
        }
        return UpToDateLineNumberProviderImpl.calcLineNumber(tracker, currentNumber);
    }

    public boolean isRangeChanged(int start, int end) {
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            return false;
        }
        for (Range range : tracker.getRanges()) {
            if (UpToDateLineNumberProviderImpl.lineInRange(range, start) || UpToDateLineNumberProviderImpl.lineInRange(range, end)) {
                return true;
            }
            if (range.getOffset1() <= start) continue;
            return range.getOffset1() < end;
        }
        return false;
    }

    private static boolean lineInRange(Range range, int currentNumber) {
        return range.getOffset1() <= currentNumber && range.getOffset2() >= currentNumber;
    }

    public boolean isLineChanged(int currentNumber) {
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            return false;
        }
        for (Range range : tracker.getRanges()) {
            if (range.getOffset1() > currentNumber || range.getOffset2() < currentNumber) continue;
            return true;
        }
        return false;
    }

    private boolean endsWithSeparator(CharSequence string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char latest = string.charAt(string.length() - 1);
        return '\n' == latest || '\r' == latest;
    }

    private String fixLatestLineSeparator(Document document, String content) {
        CharSequence documentSequence = document.getCharsSequence();
        if (this.endsWithSeparator(documentSequence) && !this.endsWithSeparator(content)) {
            char beforeLatest;
            int numCharsToCopy = 1;
            int docLen = documentSequence.length();
            if (docLen > 1 && ('\r' == (beforeLatest = documentSequence.charAt(docLen - 2)) || '\n' == beforeLatest)) {
                numCharsToCopy = 2;
            }
            return content + documentSequence.subSequence(docLen - numCharsToCopy, docLen);
        }
        return content;
    }

    private static int calcLineNumber(LineStatusTracker tracker, int currentNumber) {
        if (tracker == null) {
            return -1;
        }
        List<Range> ranges = tracker.getRanges();
        int result = currentNumber;
        Iterator<Range> i$ = ranges.iterator();
        while (i$.hasNext()) {
            Range range1;
            Range range = range1 = i$.next();
            int startOffset = range.getOffset1();
            int endOffset = range.getOffset2();
            if (startOffset <= currentNumber && endOffset > currentNumber) {
                return -1;
            }
            if (endOffset > currentNumber) {
                return result;
            }
            int currentRangeLength = endOffset - startOffset;
            result += range.getUpToDateRangeLength() - currentRangeLength;
        }
        return result;
    }
}

