/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ModuleVcsPathPresenter
extends VcsPathPresenter {
    private final Project myProject;

    public ModuleVcsPathPresenter(Project project) {
        this.myProject = project;
    }

    public String getPresentableRelativePathFor(final VirtualFile file) {
        if (file == null) {
            return "";
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)ModuleVcsPathPresenter.this.myProject).getFileIndex();
                Module module = fileIndex.getModuleForFile(file);
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                if (module == null || contentRoot == null) {
                    return file.getPresentableUrl();
                }
                StringBuffer result = new StringBuffer();
                result.append("[");
                result.append(module.getName());
                result.append("] ");
                result.append(contentRoot.getName());
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)File.separatorChar);
                if (!relativePath.isEmpty()) {
                    result.append(File.separatorChar);
                    result.append(relativePath);
                }
                return result.toString();
            }
        });
    }

    public String getPresentableRelativePath(@NotNull ContentRevision fromRevision, @NotNull ContentRevision toRevision) {
        Module newModule;
        Module oldModule;
        if (fromRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePath"));
        }
        if (toRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter", "getPresentableRelativePath"));
        }
        FilePath fromPath = fromRevision.getFile();
        FilePath toPath = toRevision.getFile();
        if (fromPath.getParentPath() == null || toPath.getParentPath() == null) {
            return null;
        }
        VirtualFile oldFile = fromPath.getParentPath().getVirtualFile();
        VirtualFile newFile = toPath.getParentPath().getVirtualFile();
        if (oldFile != null && newFile != null && (oldModule = ModuleUtilCore.findModuleForFile((VirtualFile)oldFile, (Project)this.myProject)) != (newModule = ModuleUtilCore.findModuleForFile((VirtualFile)newFile, (Project)this.myProject))) {
            return this.getPresentableRelativePathFor(oldFile);
        }
        RelativePathCalculator calculator = new RelativePathCalculator(toPath.getIOFile().getAbsolutePath(), fromPath.getIOFile().getAbsolutePath());
        calculator.execute();
        String result = calculator.getResult();
        return result == null ? null : result.replace("/", File.separator);
    }
}

