/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final MessageBus myMessageBus;
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private MessageBusConnection myConnection;

    public ModuleVcsDetector(Project project, MessageBus messageBus, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myMessageBus = messageBus;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)vcsManager;
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager manager = StartupManager.getInstance((Project)this.myProject);
        manager.registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                if (ModuleVcsDetector.this.myVcsManager.needAutodetectMappings()) {
                    ModuleVcsDetector.this.autoDetectVcsMappings(true);
                }
                ModuleVcsDetector.this.myVcsManager.updateActiveVcss();
            }
        });
        manager.registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                if (ModuleVcsDetector.this.myMessageBus != null) {
                    ModuleVcsDetector.this.myConnection = ModuleVcsDetector.this.myMessageBus.connect();
                    MyModulesListener listener = new MyModulesListener();
                    ModuleVcsDetector.this.myConnection.subscribe(ProjectTopics.MODULES, (Object)listener);
                    ModuleVcsDetector.this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener);
                }
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ModuleVcsDetector" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ModuleVcsDetector", "getComponentName"));
        }
        return "ModuleVcsDetector";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
    }

    private void autoDetectVcsMappings(boolean tryMapPieces) {
        HashSet<AbstractVcs> usedVcses = new HashSet<AbstractVcs>();
        HashMap<VirtualFile, AbstractVcs> vcsMap = new HashMap<VirtualFile, AbstractVcs>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                AbstractVcs contentRootVcs = this.myVcsManager.findVersioningVcs(file);
                if (contentRootVcs != null) {
                    vcsMap.put(file, contentRootVcs);
                }
                usedVcses.add(contentRootVcs);
            }
        }
        if (usedVcses.size() == 1) {
            AbstractVcs[] abstractVcses = usedVcses.toArray(new AbstractVcs[1]);
            Module[] modules = moduleManager.getModules();
            HashSet<String> contentRoots = new HashSet<String>();
            for (Module module : modules) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    contentRoots.add(root.getPath());
                }
            }
            if (abstractVcses[0] != null) {
                ArrayList<VcsDirectoryMapping> vcsDirectoryMappings = new ArrayList<VcsDirectoryMapping>(this.myVcsManager.getDirectoryMappings());
                Iterator iterator = vcsDirectoryMappings.iterator();
                while (iterator.hasNext()) {
                    VcsDirectoryMapping mapping = (VcsDirectoryMapping)iterator.next();
                    if (contentRoots.contains(mapping.getDirectory())) continue;
                    iterator.remove();
                }
                this.myVcsManager.setAutoDirectoryMapping("", abstractVcses[0].getName());
                for (VcsDirectoryMapping mapping : vcsDirectoryMappings) {
                    this.myVcsManager.removeDirectoryMapping(mapping);
                }
                this.myVcsManager.cleanupMappings();
            }
        } else if (tryMapPieces) {
            for (Map.Entry entry : vcsMap.entrySet()) {
                this.myVcsManager.setAutoDirectoryMapping(((VirtualFile)entry.getKey()).getPath(), entry.getValue() == null ? "" : ((AbstractVcs)entry.getValue()).getName());
            }
            this.myVcsManager.cleanupMappings();
        }
    }

    private void autoDetectModuleVcsMapping(Module module) {
        VirtualFile[] files;
        boolean mappingsUpdated = false;
        for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            AbstractVcs vcs = this.myVcsManager.findVersioningVcs(file);
            if (vcs == null || vcs == this.myVcsManager.getVcsFor(file)) continue;
            this.myVcsManager.setAutoDirectoryMapping(file.getPath(), vcs.getName());
            mappingsUpdated = true;
        }
        if (mappingsUpdated) {
            this.myVcsManager.cleanupMappings();
        }
    }

    private List<Pair<String, VcsDirectoryMapping>> getMappings(Module module) {
        ArrayList<Pair<String, VcsDirectoryMapping>> result = new ArrayList<Pair<String, VcsDirectoryMapping>>();
        VirtualFile[] files = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String moduleName = module.getName();
        block0: for (VirtualFile file : files) {
            for (VcsDirectoryMapping mapping : this.myVcsManager.getDirectoryMappings()) {
                if (!FileUtil.toSystemIndependentName((String)mapping.getDirectory()).equals(file.getPath())) continue;
                result.add((Pair<String, VcsDirectoryMapping>)new Pair((Object)moduleName, (Object)mapping));
                continue block0;
            }
        }
        return result;
    }

    private void promptRemoveMapping(final String moduleName, final VcsDirectoryMapping mapping) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ModuleVcsDetector.this.myProject.isDisposed()) {
                    return;
                }
                String msg = VcsBundle.message((String)"vcs.root.remove.prompt", (Object[])new Object[]{FileUtil.toSystemDependentName((String)mapping.getDirectory()), moduleName});
                int rc = Messages.showYesNoDialog((Project)ModuleVcsDetector.this.myProject, (String)msg, (String)VcsBundle.message((String)"vcs.root.remove.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (rc == 0) {
                    ModuleVcsDetector.this.myVcsManager.removeDirectoryMapping(mapping);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    private class MyModulesListener
    extends ModuleAdapter
    implements ModuleRootListener {
        private final List<Pair<String, VcsDirectoryMapping>> myMappingsForRemovedModules = new ArrayList<Pair<String, VcsDirectoryMapping>>();

        private MyModulesListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
            this.myMappingsForRemovedModules.clear();
        }

        public void rootsChanged(ModuleRootEvent event) {
            for (Pair<String, VcsDirectoryMapping> mapping : this.myMappingsForRemovedModules) {
                ModuleVcsDetector.this.promptRemoveMapping((String)mapping.first, (VcsDirectoryMapping)mapping.second);
            }
            if (ModuleVcsDetector.this.myVcsManager.needAutodetectMappings()) {
                ModuleVcsDetector.this.autoDetectVcsMappings(false);
            }
        }

        public void moduleAdded(Project project, Module module) {
            this.myMappingsForRemovedModules.removeAll(ModuleVcsDetector.this.getMappings(module));
            ModuleVcsDetector.this.autoDetectModuleVcsMapping(module);
        }

        public void beforeModuleRemoved(Project project, Module module) {
            this.myMappingsForRemovedModules.addAll(ModuleVcsDetector.this.getMappings(module));
        }
    }
}

