/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesUnderRoots {
    private final ChangeListManager myChangeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private VcsRoot[] myRoots;

    public LocalChangesUnderRoots(@NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "<init>"));
        }
        if (projectLevelVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "<init>"));
        }
        this.myChangeManager = changeListManager;
        this.myVcsManager = projectLevelVcsManager;
    }

    public Map<String, Map<VirtualFile, Collection<Change>>> getChangesByLists(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "getChangesByLists"));
        }
        HashMap<String, Map<VirtualFile, Collection<Change>>> result = new HashMap<String, Map<VirtualFile, Collection<Change>>>();
        this.myRoots = this.myVcsManager.getAllVcsRoots();
        List changeLists = this.myChangeManager.getChangeListsCopy();
        for (LocalChangeList list : changeLists) {
            HashMap<VirtualFile, Collection<Change>> subMap = new HashMap<VirtualFile, Collection<Change>>();
            this.addChangesToMap(rootsToSave, subMap, list.getChanges());
            result.put(list.getName(), subMap);
        }
        return result;
    }

    @NotNull
    public Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "getChangesUnderRoots"));
        }
        HashMap<VirtualFile, Collection<Change>> result = new HashMap<VirtualFile, Collection<Change>>();
        Collection allChanges = this.myChangeManager.getAllChanges();
        this.myRoots = this.myVcsManager.getAllVcsRoots();
        this.addChangesToMap(rootsToSave, result, allChanges);
        HashMap<VirtualFile, Collection<Change>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "getChangesUnderRoots"));
        }
        return hashMap;
    }

    private void addChangesToMap(Collection<VirtualFile> rootsToSave, Map<VirtualFile, Collection<Change>> result, Collection<Change> allChanges) {
        for (Change change : allChanges) {
            if (change.getBeforeRevision() != null) {
                this.addChangeToMap(result, change, change.getBeforeRevision(), rootsToSave);
            }
            if (change.getAfterRevision() == null) continue;
            this.addChangeToMap(result, change, change.getAfterRevision(), rootsToSave);
        }
    }

    private void addChangeToMap(@NotNull Map<VirtualFile, Collection<Change>> result, @NotNull Change change, @NotNull ContentRevision revision, @NotNull Collection<VirtualFile> rootsToSave) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "addChangeToMap"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "addChangeToMap"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "addChangeToMap"));
        }
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "addChangeToMap"));
        }
        VirtualFile root = this.getRootForPath(revision.getFile(), rootsToSave);
        LocalChangesUnderRoots.addChangeToMap(result, root, change);
    }

    @Nullable
    private VirtualFile getRootForPath(@NotNull FilePath file, @NotNull Collection<VirtualFile> rootsToSave) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "getRootForPath"));
        }
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "getRootForPath"));
        }
        VirtualFile vf = ChangesUtil.findValidParentUnderReadAction((FilePath)file);
        if (vf == null) {
            return null;
        }
        VirtualFile rootCandidate = null;
        for (VcsRoot root : this.myRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root.getPath(), (VirtualFile)vf, (boolean)false) || rootCandidate != null && !VfsUtil.isAncestor((VirtualFile)rootCandidate, (VirtualFile)root.getPath(), (boolean)true)) continue;
            rootCandidate = root.getPath();
        }
        if (!rootsToSave.contains(rootCandidate)) {
            return null;
        }
        return rootCandidate;
    }

    private static void addChangeToMap(@NotNull Map<VirtualFile, Collection<Change>> result, @Nullable VirtualFile root, @NotNull Change change) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "addChangeToMap"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots", "addChangeToMap"));
        }
        if (root == null) {
            return;
        }
        Collection<Change> changes = result.get(root);
        if (changes == null) {
            changes = new HashSet<Change>();
            result.put(root, changes);
        }
        changes.add(change);
    }
}

