/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessorRemovePartner;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LineStatusTrackerManager
implements ProjectComponent,
LineStatusTrackerManagerI {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
    public final Object myLock = new Object();
    private final Project myProject;
    private final Map<Document, LineStatusTracker> myLineStatusTrackers;
    private final QueueProcessorRemovePartner<Document, BaseRevisionLoader> myPartner;
    @NonNls
    protected static final String IGNORE_CHANGEMARKERS_KEY = "idea.ignore.changemarkers";
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsBaseContentProvider myStatusProvider;
    private final Application myApplication;
    private final FileEditorManager myFileEditorManager;
    private final Disposable myDisposable;
    private long myLoadCounter = 0L;

    public static LineStatusTrackerManagerI getInstance(Project project) {
        if (System.getProperty(IGNORE_CHANGEMARKERS_KEY) != null) {
            return LineStatusTrackerManagerI.Dummy.getInstance();
        }
        return (LineStatusTrackerManagerI)PeriodicalTasksCloser.getInstance().safeGetComponent(project, LineStatusTrackerManagerI.class);
    }

    public LineStatusTrackerManager(Project project, ProjectLevelVcsManager vcsManager, VcsBaseContentProvider statusProvider, Application application, FileEditorManager fileEditorManager, DirectoryIndex makeSureIndexIsInitializedFirst) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myStatusProvider = statusProvider;
        this.myApplication = application;
        this.myFileEditorManager = fileEditorManager;
        this.myLineStatusTrackers = new HashMap();
        this.myPartner = new QueueProcessorRemovePartner(this.myProject, (Consumer)new Consumer<BaseRevisionLoader>(){

            public void consume(BaseRevisionLoader baseRevisionLoader) {
                baseRevisionLoader.run();
            }
        });
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$2", "updateStarted"));
                }
                LineStatusTracker tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc);
                if (tracker != null) {
                    tracker.startBulkUpdate();
                }
            }

            @Override
            public void updateFinished(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$2", "updateFinished"));
                }
                LineStatusTracker tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc);
                if (tracker != null) {
                    tracker.finishBulkUpdate();
                }
            }
        });
        this.myDisposable = new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = LineStatusTrackerManager.this.myLock;
                synchronized (object) {
                    for (LineStatusTracker tracker : LineStatusTrackerManager.this.myLineStatusTrackers.values()) {
                        Document document = tracker.getDocument();
                        LineStatusTrackerManager.this.myPartner.remove((Object)document);
                        tracker.release();
                    }
                    LineStatusTrackerManager.this.myLineStatusTrackers.clear();
                    assert (LineStatusTrackerManager.this.myPartner.isEmpty());
                    LineStatusTrackerManager.this.myPartner.clear();
                }
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                final MyFileStatusListener fileStatusListener = new MyFileStatusListener();
                MyEditorFactoryListener editorFactoryListener = new MyEditorFactoryListener();
                final MyVirtualFileListener virtualFileListener = new MyVirtualFileListener();
                final EditorColorsListener editorColorsListener = new EditorColorsListener(){

                    public void globalSchemeChange(EditorColorsScheme scheme) {
                        LineStatusTrackerManager.this.resetTrackersForOpenFiles();
                    }
                };
                final FileStatusManager fsManager = FileStatusManager.getInstance((Project)LineStatusTrackerManager.this.myProject);
                fsManager.addFileStatusListener((FileStatusListener)fileStatusListener, (Disposable)LineStatusTrackerManager.this.myProject);
                EditorFactory editorFactory = EditorFactory.getInstance();
                editorFactory.addEditorFactoryListener((EditorFactoryListener)editorFactoryListener, (Disposable)LineStatusTrackerManager.this.myProject);
                final VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                virtualFileManager.addVirtualFileListener((VirtualFileListener)virtualFileListener, (Disposable)LineStatusTrackerManager.this.myProject);
                final EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                editorColorsManager.addEditorColorsListener(editorColorsListener);
                Disposer.register((Disposable)LineStatusTrackerManager.this.myDisposable, (Disposable)new Disposable(){

                    public void dispose() {
                        fsManager.removeFileStatusListener((FileStatusListener)fileStatusListener);
                        virtualFileManager.removeVirtualFileListener((VirtualFileListener)virtualFileListener);
                        editorColorsManager.removeEditorColorsListener(editorColorsListener);
                    }
                });
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LineStatusTrackerManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "getComponentName"));
        }
        return "LineStatusTrackerManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LineStatusTracker getLineStatusTracker(Document document) {
        this.myApplication.assertReadAccessAllowed();
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myLineStatusTrackers.get(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTracker(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager", "resetTracker"));
        }
        this.myApplication.assertReadAccessAllowed();
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document == null) {
            LineStatusTrackerManager.log("Skipping resetTracker() because no cached document for " + virtualFile.getPath());
            return;
        }
        LineStatusTrackerManager.log("resetting tracker for file " + virtualFile.getPath());
        boolean editorOpened = this.myFileEditorManager.isFileOpen(virtualFile);
        boolean shouldBeInstalled = this.shouldBeInstalled(virtualFile) && editorOpened;
        Object object = this.myLock;
        synchronized (object) {
            LineStatusTracker tracker = this.myLineStatusTrackers.get(document);
            if (tracker == null && !shouldBeInstalled) {
                return;
            }
            if (tracker != null) {
                this.releaseTracker(document);
            }
            if (shouldBeInstalled) {
                this.installTracker(virtualFile, document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTracker(Document document) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPartner.remove((Object)document);
            LineStatusTracker tracker = this.myLineStatusTrackers.remove(document);
            if (tracker != null) {
                tracker.release();
            }
        }
    }

    private boolean shouldBeInstalled(VirtualFile virtualFile) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return false;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return false;
        }
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return false;
        }
        FileStatusManager statusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (statusManager == null) {
            return false;
        }
        AbstractVcs activeVcs = this.myVcsManager.getVcsFor(virtualFile);
        if (activeVcs == null) {
            LineStatusTrackerManager.log("installTracker() for file " + virtualFile.getPath() + " failed: no active VCS");
            return false;
        }
        FileStatus status = statusManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED || status == FileStatus.ADDED || status == FileStatus.UNKNOWN || status == FileStatus.IGNORED) {
            LineStatusTrackerManager.log("installTracker() for file " + virtualFile.getPath() + " failed: status=" + status);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installTracker(VirtualFile virtualFile, Document document) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLineStatusTrackers.containsKey(document)) {
                return;
            }
            assert (!this.myPartner.containsKey((Object)document));
            LineStatusTracker tracker = LineStatusTracker.createOn(virtualFile, document, this.myProject);
            this.myLineStatusTrackers.put(document, tracker);
            this.startAlarm(document, virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAlarm(Document document, VirtualFile virtualFile) {
        this.myApplication.assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            this.myPartner.add((Object)document, (Object)new BaseRevisionLoader(document, virtualFile));
        }
    }

    private void resetTrackersForOpenFiles() {
        VirtualFile[] openFiles;
        this.myApplication.assertReadAccessAllowed();
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile openFile : openFiles = this.myFileEditorManager.getOpenFiles()) {
            this.resetTracker(openFile);
        }
    }

    private static void log(String s) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(s);
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener", "beforeContentsChange"));
            }
            if (event.isFromRefresh()) {
                LineStatusTrackerManager.this.resetTracker(event.getFile());
            }
        }
    }

    private class MyEditorFactoryListener
    extends EditorFactoryAdapter {
        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener", "editorCreated"));
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != LineStatusTrackerManager.this.myProject) {
                return;
            }
            final Document document = editor.getDocument();
            final VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            new AbstractCalledLater(LineStatusTrackerManager.this.myProject, ModalityState.NON_MODAL){

                @Override
                public void run() {
                    if (LineStatusTrackerManager.this.shouldBeInstalled(virtualFile)) {
                        LineStatusTrackerManager.this.installTracker(virtualFile, document);
                    }
                }
            }.callMe();
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener", "editorReleased"));
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != LineStatusTrackerManager.this.myProject) {
                return;
            }
            final Document doc = editor.getDocument();
            Editor[] editors = event.getFactory().getEditors(doc, LineStatusTrackerManager.this.myProject);
            if (editors.length == 0) {
                new AbstractCalledLater(LineStatusTrackerManager.this.myProject, ModalityState.NON_MODAL){

                    @Override
                    public void run() {
                        LineStatusTrackerManager.this.releaseTracker(doc);
                    }
                }.callMe();
            }
        }
    }

    private class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            if (LineStatusTrackerManager.this.myProject.isDisposed()) {
                return;
            }
            LineStatusTrackerManager.log("LineStatusTrackerManager: fileStatusesChanged");
            LineStatusTrackerManager.this.resetTrackersForOpenFiles();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener", "fileStatusChanged"));
            }
            LineStatusTrackerManager.this.resetTracker(virtualFile);
        }
    }

    private class BaseRevisionLoader
    implements Runnable {
        private final VirtualFile myVirtualFile;
        private final Document myDocument;

        private BaseRevisionLoader(Document document, VirtualFile virtualFile) {
            this.myDocument = document;
            this.myVirtualFile = virtualFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!LineStatusTrackerManager.this.myProject.isOpen() || LineStatusTrackerManager.this.myProject.isDisposed()) {
                return;
            }
            if (!this.myVirtualFile.isValid()) {
                LineStatusTrackerManager.log("installTracker() for file " + this.myVirtualFile.getPath() + " failed: virtual file not valid");
                this.reportTrackerBaseLoadFailed();
                return;
            }
            VcsRevisionNumber baseRevision = LineStatusTrackerManager.this.myStatusProvider.getBaseRevision(this.myVirtualFile);
            if (baseRevision == null) {
                LineStatusTrackerManager.log("installTracker() for file " + this.myVirtualFile.getPath() + " failed: null returned for base revision number");
                this.reportTrackerBaseLoadFailed();
                return;
            }
            final LineStatusTracker.RevisionPack revisionPack = new LineStatusTracker.RevisionPack(LineStatusTrackerManager.this.myLoadCounter, baseRevision);
            ++LineStatusTrackerManager.this.myLoadCounter;
            Object object = LineStatusTrackerManager.this.myLock;
            synchronized (object) {
                final LineStatusTracker tracker = (LineStatusTracker)LineStatusTrackerManager.this.myLineStatusTrackers.get(this.myDocument);
                if (tracker != null && tracker.canUseBaseRevision(revisionPack)) {
                    this.nonModalAliveInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LineStatusTrackerManager.log("installTracker() for file " + BaseRevisionLoader.this.myVirtualFile.getPath() + " base revision number already in tracker");
                            tracker.useCachedBaseRevision(revisionPack);
                        }
                    });
                    return;
                }
            }
            String lastUpToDateContent = LineStatusTrackerManager.this.myStatusProvider.getBaseVersionContent(this.myVirtualFile);
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.log("installTracker() for file " + this.myVirtualFile.getPath() + " failed: no up to date content");
                this.reportTrackerBaseLoadFailed();
                return;
            }
            final String converted = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LineStatusTrackerManager.this.myLock;
                    synchronized (object) {
                        LineStatusTrackerManager.log("initializing tracker for file " + BaseRevisionLoader.this.myVirtualFile.getPath());
                        LineStatusTracker tracker = (LineStatusTracker)LineStatusTrackerManager.this.myLineStatusTrackers.get(BaseRevisionLoader.this.myDocument);
                        if (tracker != null) {
                            tracker.initialize(converted, revisionPack);
                        }
                    }
                }
            };
            this.nonModalAliveInvokeLater(runnable);
        }

        private void nonModalAliveInvokeLater(Runnable runnable) {
            LineStatusTrackerManager.this.myApplication.invokeLater(runnable, ModalityState.NON_MODAL, new Condition(){

                public boolean value(Object ignore) {
                    return !LineStatusTrackerManager.this.myProject.isOpen() || LineStatusTrackerManager.this.myProject.isDisposed();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportTrackerBaseLoadFailed() {
            Object object = LineStatusTrackerManager.this.myLock;
            synchronized (object) {
                LineStatusTrackerManager.log("base revision load failed for file " + this.myVirtualFile.getPath());
                LineStatusTracker tracker = (LineStatusTracker)LineStatusTrackerManager.this.myLineStatusTrackers.get(this.myDocument);
                if (tracker != null) {
                    tracker.baseRevisionLoadFailed();
                }
            }
        }
    }
}

