/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericNotifierImpl<T, Key> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.GenericNotifier");
    protected final Project myProject;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final NotificationType myType;
    @NotNull
    private final Map<Key, MyNotification> myState;
    private final MyListener myListener;
    private final Object myLock;

    protected GenericNotifierImpl(Project project, @NotNull String groupId, @NotNull String title, @NotNull NotificationType type) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/GenericNotifierImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vcs/impl/GenericNotifierImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vcs/impl/GenericNotifierImpl", "<init>"));
        }
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myType = type;
        this.myProject = project;
        this.myState = new HashMap<Key, MyNotification>();
        this.myListener = new MyListener();
        this.myLock = new Object();
    }

    protected abstract boolean ask(T var1, String var2);

    @NotNull
    protected abstract Key getKey(T var1);

    @NotNull
    protected abstract String getNotificationContent(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Key> getAllCurrentKeys() {
        Object object = this.myLock;
        synchronized (object) {
            return new ArrayList<Key>(this.myState.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getStateFor(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<MyNotification> notifications;
        Object object = this.myLock;
        synchronized (object) {
            notifications = new ArrayList<MyNotification>(this.myState.values());
            this.myState.clear();
        }
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (MyNotification notification : notifications) {
                    notification.expire();
                }
            }
        };
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable, ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    private void expireNotification(final MyNotification notification) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                notification.expire();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureNotify(T obj) {
        MyNotification notification;
        Object object = this.myLock;
        synchronized (object) {
            Key key = this.getKey(obj);
            if (this.myState.containsKey(key)) {
                return false;
            }
            notification = new MyNotification(this.myGroupId, this.myTitle, this.getNotificationContent(obj), this.myType, this.myListener, obj);
            this.myState.put(key, notification);
        }
        boolean state = this.onFirstNotification(obj);
        if (state) {
            this.removeLazyNotification(obj);
            return true;
        }
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        return false;
    }

    protected boolean onFirstNotification(T obj) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyNotificationByKey(Key key) {
        MyNotification notification;
        Object object = this.myLock;
        synchronized (object) {
            notification = this.myState.get(key);
            if (notification != null) {
                this.myState.remove(key);
            }
        }
        if (notification != null) {
            this.expireNotification(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyNotification(T obj) {
        MyNotification notification;
        Object object = this.myLock;
        synchronized (object) {
            Key key = this.getKey(obj);
            notification = this.myState.get(key);
            if (notification != null) {
                this.myState.remove(key);
            }
        }
        if (notification != null) {
            this.expireNotification(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T getObj(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            MyNotification notification = this.myState.get(key);
            return notification == null ? null : (T)notification.getObj();
        }
    }

    private static void log(String s) {
        LOG.debug(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.isEmpty();
        }
    }

    protected class MyNotification
    extends Notification {
        private final T myObj;

        protected MyNotification(@NotNull String groupId, @NotNull String title, @NotNull String content, @Nullable NotificationType type, @NotNull NotificationListener listener, T obj) {
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification", "<init>"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification", "<init>"));
            }
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification", "<init>"));
            }
            super(groupId, title, content, type, listener);
            this.myObj = obj;
        }

        public T getObj() {
            return this.myObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            super.expire();
            Object object = GenericNotifierImpl.this.myLock;
            synchronized (object) {
                GenericNotifierImpl.this.myState.remove(GenericNotifierImpl.this.getKey(this.myObj));
            }
        }
    }

    private class MyListener
    implements NotificationListener {
        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyListener", "hyperlinkUpdate"));
            }
            MyNotification concreteNotification = (MyNotification)notification;
            Object obj = concreteNotification.getObj();
            boolean state = GenericNotifierImpl.this.ask(obj, event.getDescription());
            if (state) {
                Object object = GenericNotifierImpl.this.myLock;
                synchronized (object) {
                    Object key = GenericNotifierImpl.this.getKey(obj);
                    GenericNotifierImpl.this.myState.remove(key);
                }
                GenericNotifierImpl.this.expireNotification(concreteNotification);
            }
        }
    }
}

