/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.LineStatusTracker");
    private static final Key<CanNotCalculateDiffPanel> PANEL_KEY = new Key("LineStatusTracker.CanNotCalculateDiffPanel");
    private final Object myLock = new Object();
    private BaseLoadState myBaseLoaded;
    private final Document myDocument;
    private final Document myUpToDateDocument;
    private List<Range> myRanges;
    private final Project myProject;
    private MyDocumentListener myDocumentListener;
    private boolean myBulkUpdate;
    private final Application myApplication;
    @Nullable
    private RevisionPack myBaseRevisionNumber;
    private String myPreviousBaseRevision;
    private boolean myAnathemaThrown;
    private FileEditorManager myFileEditorManager;
    private final VirtualFile myVirtualFile;
    private boolean myReleased = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineStatusTracker(Document document, Document upToDateDocument, Project project, VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
        this.myApplication = ApplicationManager.getApplication();
        this.myDocument = document;
        this.myUpToDateDocument = upToDateDocument;
        this.myUpToDateDocument.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        this.myProject = project;
        this.myBaseLoaded = BaseLoadState.LOADING;
        Object object = this.myLock;
        synchronized (object) {
            this.myRanges = new ArrayList<Range>();
        }
        this.myAnathemaThrown = false;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(@NotNull String upToDateContent, @NotNull RevisionPack baseRevisionNumber) {
        if (upToDateContent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/ex/LineStatusTracker", "initialize"));
        }
        if (baseRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/ex/LineStatusTracker", "initialize"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            try {
                if (this.myReleased) {
                    return;
                }
                if (this.myBaseRevisionNumber != null && this.myBaseRevisionNumber.after(baseRevisionNumber)) {
                    return;
                }
                this.myBaseRevisionNumber = baseRevisionNumber;
                this.myPreviousBaseRevision = null;
                this.myUpToDateDocument.setReadOnly(false);
                this.myUpToDateDocument.replaceString(0, this.myUpToDateDocument.getTextLength(), (CharSequence)upToDateContent);
                this.myUpToDateDocument.setReadOnly(true);
                this.reinstallRanges();
                if (this.myDocumentListener != null) return;
                this.myDocumentListener = new MyDocumentListener();
                this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
            }
            finally {
                this.myBaseLoaded = BaseLoadState.LOADED;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useCachedBaseRevision(RevisionPack number) {
        Object object = this.myLock;
        synchronized (object) {
            assert (this.myBaseRevisionNumber != null);
            if (this.myPreviousBaseRevision == null || this.myBaseRevisionNumber.after(number)) {
                return;
            }
            this.initialize(this.myPreviousBaseRevision, number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUseBaseRevision(RevisionPack number) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myBaseRevisionNumber != null && this.myBaseRevisionNumber.equals(number) && this.myPreviousBaseRevision != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinstallRanges() {
        this.myApplication.assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            this.removeAnathema();
            this.removeHighlightersFromMarkupModel();
            try {
                this.myRanges = new RangesBuilder(this.myDocument, this.myUpToDateDocument).getRanges();
            }
            catch (FilesTooBigForDiffException e) {
                this.myRanges.clear();
                this.installAnathema();
                return;
            }
            for (Range range : this.myRanges) {
                range.setHighlighter(this.createHighlighter(range));
            }
        }
    }

    private void removeAnathema() {
        FileEditor[] editors;
        if (!this.myAnathemaThrown) {
            return;
        }
        this.myAnathemaThrown = false;
        for (FileEditor editor : editors = this.myFileEditorManager.getEditors(this.myVirtualFile)) {
            CanNotCalculateDiffPanel panel = (CanNotCalculateDiffPanel)((Object)editor.getUserData(PANEL_KEY));
            if (panel == null) continue;
            this.myFileEditorManager.removeTopComponent(editor, (JComponent)((Object)panel));
            editor.putUserData(PANEL_KEY, null);
        }
    }

    private RangeHighlighter createHighlighter(Range range) {
        LOG.assertTrue(!this.myReleased, (Object)"Already released");
        int first = range.getOffset1() >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getOffset1());
        int second = range.getOffset2() >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getOffset2());
        RangeHighlighter highlighter = DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true).addRangeHighlighter(first, second, 999, null, HighlighterTargetArea.LINES_IN_RANGE);
        TextAttributes attr = LineStatusTrackerDrawing.getAttributesFor(range);
        highlighter.setErrorStripeMarkColor(attr.getErrorStripeColor());
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        highlighter.setLineMarkerRenderer(LineStatusTrackerDrawing.createRenderer(range, this));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        int line1 = this.myDocument.getLineNumber(first);
        int line2 = this.myDocument.getLineNumber(second);
        String tooltip = line1 == line2 ? VcsBundle.message((String)"tooltip.text.line.changed", (Object[])new Object[]{line1}) : VcsBundle.message((String)"tooltip.text.lines.changed", (Object[])new Object[]{line1, line2});
        highlighter.setErrorStripeTooltip((Object)tooltip);
        return highlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDocumentListener != null) {
                this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
            }
            this.removeAnathema();
            this.removeHighlightersFromMarkupModel();
            this.myReleased = true;
        }
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Range> getRanges() {
        this.myApplication.assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            return this.myRanges;
        }
    }

    public Document getUpToDateDocument() {
        this.myApplication.assertIsDispatchThread();
        return this.myUpToDateDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkUpdate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.myBulkUpdate = true;
            this.removeAnathema();
            this.removeHighlightersFromMarkupModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHighlightersFromMarkupModel() {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (range.getHighlighter() == null) continue;
                range.getHighlighter().dispose();
            }
            this.myRanges.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkUpdate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.myBulkUpdate = false;
            this.reinstallRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForBaseRevisionLoad() {
        this.myApplication.assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            if (BaseLoadState.LOADED.equals((Object)this.myBaseLoaded) && this.myPreviousBaseRevision == null) {
                this.myPreviousBaseRevision = this.myUpToDateDocument.getText();
            }
            this.myUpToDateDocument.setReadOnly(false);
            this.myUpToDateDocument.setText((CharSequence)"");
            this.myUpToDateDocument.setReadOnly(true);
            this.removeAnathema();
            this.removeHighlightersFromMarkupModel();
            this.myBaseLoaded = BaseLoadState.LOADING;
        }
    }

    private List<Range> getChangedRanges(int from, int to) {
        return LineStatusTracker.getChangedRanges(this.myRanges, from, to);
    }

    public static List<Range> getChangedRanges(List<Range> ranges, int from, int to) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : ranges) {
            if (range.getOffset1() > to || range.getOffset2() < from) continue;
            result.add(range);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Range getNextRange(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            int index = this.myRanges.indexOf(range);
            if (index == this.myRanges.size() - 1) {
                return null;
            }
            return this.myRanges.get(index + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Range getPrevRange(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            int index = this.myRanges.indexOf(range);
            if (index <= 0) {
                return null;
            }
            return this.myRanges.get(index - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(int line) {
        Object object = this.myLock;
        synchronized (object) {
            Range currentRange = this.getRangeForLine(line);
            if (currentRange != null) {
                return this.getNextRange(currentRange);
            }
            for (Range range : this.myRanges) {
                if (line > range.getOffset1() || line > range.getOffset2()) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(int line) {
        Object object = this.myLock;
        synchronized (object) {
            Range currentRange = this.getRangeForLine(line);
            if (currentRange != null) {
                return this.getPrevRange(currentRange);
            }
            ListIterator<Range> iterator = this.myRanges.listIterator(this.myRanges.size());
            while (iterator.hasPrevious()) {
                Range range = iterator.previous();
                if (range.getOffset1() > line) continue;
                return range;
            }
            return null;
        }
    }

    public static List<Range> getRangesBefore(List<Range> ranges, int line) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : ranges) {
            if (range.getOffset2() >= line) continue;
            result.add(range);
        }
        return result;
    }

    public static List<Range> getRangesAfter(List<Range> ranges, int line) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : ranges) {
            if (range.getOffset1() <= line) continue;
            result.add(range);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getRangeForLine(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (range.getType() == 3 && line == range.getOffset1()) {
                    return range;
                }
                if (line < range.getOffset1() || line >= range.getOffset2()) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges(Range range) {
        this.myApplication.assertWriteAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            TextRange currentTextRange = this.getCurrentTextRange(range);
            if (range.getType() == 2) {
                this.myDocument.replaceString(currentTextRange.getStartOffset(), Math.min(currentTextRange.getEndOffset() + 1, this.myDocument.getTextLength()), (CharSequence)"");
            } else if (range.getType() == 3) {
                String upToDateContent = this.getUpToDateContent(range);
                this.myDocument.insertString(currentTextRange.getStartOffset(), (CharSequence)upToDateContent);
            } else {
                String upToDateContent = this.getUpToDateContent(range);
                this.myDocument.replaceString(currentTextRange.getStartOffset(), Math.min(currentTextRange.getEndOffset() + 1, this.myDocument.getTextLength()), (CharSequence)upToDateContent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUpToDateContent(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            TextRange textRange = this.getUpToDateRange(range);
            int startOffset = textRange.getStartOffset();
            int endOffset = Math.min(textRange.getEndOffset() + 1, this.myUpToDateDocument.getTextLength());
            return ((Object)this.myUpToDateDocument.getCharsSequence().subSequence(startOffset, endOffset)).toString();
        }
    }

    Project getProject() {
        return this.myProject;
    }

    TextRange getCurrentTextRange(Range range) {
        return LineStatusTracker.getRange(range.getType(), range.getOffset1(), range.getOffset2(), (byte)3, this.myDocument, false);
    }

    TextRange getUpToDateRange(Range range) {
        return LineStatusTracker.getRange(range.getType(), range.getUOffset1(), range.getUOffset2(), (byte)2, this.myUpToDateDocument, false);
    }

    TextRange getCurrentTextRangeWithEndSymbol(Range range) {
        return LineStatusTracker.getRange(range.getType(), range.getOffset1(), range.getOffset2(), (byte)3, this.myDocument, true);
    }

    TextRange getUpToDateRangeWithEndSymbol(Range range) {
        return LineStatusTracker.getRange(range.getType(), range.getUOffset1(), range.getUOffset2(), (byte)2, this.myUpToDateDocument, true);
    }

    private static TextRange getRange(byte rangeType, int offset1, int offset2, byte emptyRangeCondition, Document document, boolean keepEnd) {
        if (rangeType == emptyRangeCondition) {
            int lineStartOffset = offset1 == 0 ? 0 : document.getLineEndOffset(offset1 - 1);
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = document.getLineStartOffset(offset1);
        int endOffset = document.getLineEndOffset(offset2 - 1);
        if (startOffset > 0) {
            --startOffset;
            if (!keepEnd) {
                --endOffset;
            }
        }
        return new TextRange(startOffset, endOffset);
    }

    public static LineStatusTracker createOn(@Nullable VirtualFile virtualFile, Document doc, Project project) {
        DocumentImpl document = new DocumentImpl("", true);
        return new LineStatusTracker(doc, document, project, virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void baseRevisionLoadFailed() {
        Object object = this.myLock;
        synchronized (object) {
            this.myBaseLoaded = BaseLoadState.FAILED;
        }
    }

    private void installAnathema() {
        FileEditor[] editors;
        this.myAnathemaThrown = true;
        for (FileEditor editor : editors = this.myFileEditorManager.getAllEditors(this.myVirtualFile)) {
            CanNotCalculateDiffPanel panel = (CanNotCalculateDiffPanel)((Object)editor.getUserData(PANEL_KEY));
            if (panel != null) continue;
            CanNotCalculateDiffPanel newPanel = new CanNotCalculateDiffPanel();
            editor.putUserData(PANEL_KEY, (Object)newPanel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)newPanel));
        }
    }

    public static class CanNotCalculateDiffPanel
    extends EditorNotificationPanel {
        public CanNotCalculateDiffPanel() {
            this.myLabel.setText("Can not highlight changed lines. File is too big and there are too many changes.");
        }
    }

    public static class RevisionPack {
        private final long myNumber;
        private final VcsRevisionNumber myRevision;

        public RevisionPack(long number, VcsRevisionNumber revision) {
            this.myNumber = number;
            this.myRevision = revision;
        }

        public long getNumber() {
            return this.myNumber;
        }

        public VcsRevisionNumber getRevision() {
            return this.myRevision;
        }

        public boolean after(RevisionPack previous) {
            if (this.myRevision.equals(previous.getRevision())) {
                return false;
            }
            return this.myNumber > previous.getNumber();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RevisionPack that = (RevisionPack)o;
            return this.myRevision.equals(that.getRevision());
        }

        public int hashCode() {
            return this.myRevision.hashCode();
        }
    }

    public static enum BaseLoadState {
        LOADING,
        FAILED,
        LOADED;

    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private int myFirstChangedLine;
        private int myUpToDateFirstLine;
        private int myUpToDateLastLine;
        private int myLastChangedLine;
        private int myLinesBeforeChange;
        private final VcsDirtyScopeManager myVcsDirtyScopeManager;

        private MyDocumentListener() {
            this.myVcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)LineStatusTracker.this.myProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(DocumentEvent e) {
            LineStatusTracker.this.myApplication.assertWriteAccessAllowed();
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                if (LineStatusTracker.this.myReleased) {
                    return;
                }
                if (LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.myAnathemaThrown || BaseLoadState.LOADED != LineStatusTracker.this.myBaseLoaded) {
                    return;
                }
                try {
                    this.myFirstChangedLine = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
                    this.myLastChangedLine = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength());
                    if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n')) {
                        ++this.myLastChangedLine;
                    }
                    this.myLinesBeforeChange = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength()) - LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
                    Range firstChangedRange = this.getLastRangeBeforeLine(this.myFirstChangedLine);
                    if (firstChangedRange == null) {
                        this.myUpToDateFirstLine = this.myFirstChangedLine;
                    } else if (firstChangedRange.containsLine(this.myFirstChangedLine)) {
                        this.myFirstChangedLine = firstChangedRange.getOffset1();
                        this.myUpToDateFirstLine = firstChangedRange.getUOffset1();
                    } else {
                        this.myUpToDateFirstLine = firstChangedRange.getUOffset2() + this.myFirstChangedLine - firstChangedRange.getOffset2();
                    }
                    Range myLastChangedRange = this.getLastRangeBeforeLine(this.myLastChangedLine);
                    if (myLastChangedRange == null) {
                        this.myUpToDateLastLine = this.myLastChangedLine;
                    } else if (myLastChangedRange.containsLine(this.myLastChangedLine)) {
                        this.myUpToDateLastLine = myLastChangedRange.getUOffset2();
                        this.myLastChangedLine = myLastChangedRange.getOffset2();
                    } else {
                        this.myUpToDateLastLine = myLastChangedRange.getUOffset2() + this.myLastChangedLine - myLastChangedRange.getOffset2();
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        }

        @Nullable
        private Range getLastRangeBeforeLine(int line) {
            Range result = null;
            for (Range range : LineStatusTracker.this.myRanges) {
                if (range.isAfter(line)) {
                    return result;
                }
                result = range;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(final DocumentEvent e) {
            LineStatusTracker.this.myApplication.assertWriteAccessAllowed();
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                if (LineStatusTracker.this.myReleased) {
                    return;
                }
                if (LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.myAnathemaThrown || BaseLoadState.LOADED != LineStatusTracker.this.myBaseLoaded) {
                    return;
                }
                try {
                    int line = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getNewLength());
                    int linesAfterChange = line - LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
                    int linesShift = linesAfterChange - this.myLinesBeforeChange;
                    List<Range> rangesAfterChange = LineStatusTracker.getRangesAfter(LineStatusTracker.this.myRanges, this.myLastChangedLine);
                    List<Range> rangesBeforeChange = LineStatusTracker.getRangesBefore(LineStatusTracker.this.myRanges, this.myFirstChangedLine);
                    List changedRanges = LineStatusTracker.this.getChangedRanges(this.myFirstChangedLine, this.myLastChangedLine);
                    int newSize = rangesBeforeChange.size() + changedRanges.size() + rangesAfterChange.size();
                    if (LineStatusTracker.this.myRanges.size() != newSize) {
                        LOG.info("Ranges: " + LineStatusTracker.this.myRanges + "; first changed line: " + this.myFirstChangedLine + "; last changed line: " + this.myLastChangedLine);
                        LOG.assertTrue(false);
                    }
                    this.myLastChangedLine += linesShift;
                    List<Range> newChangedRanges = this.getNewChangedRanges();
                    this.shiftRanges(rangesAfterChange, linesShift);
                    if (!((Object)changedRanges).equals(newChangedRanges)) {
                        this.replaceRanges(changedRanges, newChangedRanges);
                        LineStatusTracker.this.myRanges = new ArrayList();
                        LineStatusTracker.this.myRanges.addAll(rangesBeforeChange);
                        LineStatusTracker.this.myRanges.addAll(newChangedRanges);
                        LineStatusTracker.this.myRanges.addAll(rangesAfterChange);
                        LineStatusTracker.this.myRanges = this.mergeRanges(LineStatusTracker.this.myRanges);
                        for (Range range : LineStatusTracker.this.myRanges) {
                            if (range.hasHighlighter()) continue;
                            range.setHighlighter(LineStatusTracker.this.createHighlighter(range));
                        }
                        if (LineStatusTracker.this.myRanges.isEmpty() && LineStatusTracker.this.myVirtualFile != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    FileDocumentManager.getInstance().saveDocument(e.getDocument());
                                    boolean[] stillEmpty = new boolean[1];
                                    Object object = LineStatusTracker.this.myLock;
                                    synchronized (object) {
                                        stillEmpty[0] = LineStatusTracker.this.myRanges.isEmpty();
                                    }
                                    if (stillEmpty[0]) {
                                        MyDocumentListener.this.myVcsDirtyScopeManager.fileDirty(LineStatusTracker.this.myVirtualFile);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (ProcessCanceledException ignore) {
                }
                catch (FilesTooBigForDiffException e1) {
                    LineStatusTracker.this.installAnathema();
                    LineStatusTracker.this.removeHighlightersFromMarkupModel();
                }
            }
        }

        private List<Range> getNewChangedRanges() throws FilesTooBigForDiffException {
            List<String> lines = new DocumentWrapper(LineStatusTracker.this.myDocument).getLines(this.myFirstChangedLine, this.myLastChangedLine);
            List<String> uLines = new DocumentWrapper(LineStatusTracker.this.myUpToDateDocument).getLines(this.myUpToDateFirstLine, this.myUpToDateLastLine);
            return new RangesBuilder(lines, uLines, this.myFirstChangedLine, this.myUpToDateFirstLine).getRanges();
        }

        private List<Range> mergeRanges(List<Range> ranges) {
            ArrayList<Range> result = new ArrayList<Range>();
            Iterator<Range> iterator = ranges.iterator();
            if (!iterator.hasNext()) {
                return result;
            }
            Range prev = iterator.next();
            while (iterator.hasNext()) {
                Range range = iterator.next();
                if (prev.canBeMergedWith(range)) {
                    if (range.getHighlighter() != null) {
                        range.getHighlighter().dispose();
                    }
                    if (prev.getHighlighter() != null) {
                        prev.getHighlighter().dispose();
                    }
                    prev = prev.mergeWith(range);
                    continue;
                }
                result.add(prev);
                prev = range;
            }
            result.add(prev);
            return result;
        }

        private void replaceRanges(List<Range> rangesInChange, List<Range> newRangesInChange) {
            for (Range range : rangesInChange) {
                range.getHighlighter().dispose();
                range.setHighlighter(null);
            }
            for (Range range : newRangesInChange) {
                range.setHighlighter(LineStatusTracker.this.createHighlighter(range));
            }
        }

        private void shiftRanges(List<Range> rangesAfterChange, int shift) {
            for (Range aRangesAfterChange : rangesAfterChange) {
                aRangesAfterChange.shift(shift);
            }
        }
    }
}

