/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.checkin.BeforeCheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.optimize.imports.before.commit", (Object[])new Object[0]);
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public OptimizeImportsBeforeCheckinHandler(Project project, CheckinProjectPanel panel) {
        this.myProject = project;
        this.myPanel = panel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox optimizeBox = new JCheckBox(VcsBundle.message((String)"checkbox.checkin.options.optimize.imports", (Object[])new Object[0]));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel = new JPanel(new GridLayout(1, 0));
                panel.add(optimizeBox);
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                OptimizeImportsBeforeCheckinHandler.this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = optimizeBox.isSelected();
            }

            public void restoreState() {
                optimizeBox.setSelected(OptimizeImportsBeforeCheckinHandler.this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(final Runnable finishAction) {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        Collection files = this.myPanel.getVirtualFiles();
        Runnable performCheckoutAction = new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                finishAction.run();
            }
        };
        if (configuration.OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT) {
            new OptimizeImportsProcessor(this.myProject, BeforeCheckinHandlerUtil.getPsiFiles(this.myProject, files), COMMAND_NAME, performCheckoutAction).run();
        } else {
            finishAction.run();
        }
    }
}

