/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CodeAnalysisBeforeCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinPanel;
    private static final Logger LOG = Logger.getInstance((String)("#" + CodeAnalysisBeforeCheckinHandler.class.getName()));

    public CodeAnalysisBeforeCheckinHandler(Project project, CheckinProjectPanel panel) {
        this.myProject = project;
        this.myCheckinPanel = panel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox checkBox = new JCheckBox(VcsBundle.message((String)"before.checkin.standard.options.check.smells", (Object[])new Object[0]));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add(checkBox);
                CodeAnalysisBeforeCheckinHandler.this.refreshEnable(checkBox);
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                ((CodeAnalysisBeforeCheckinHandler)CodeAnalysisBeforeCheckinHandler.this).getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = checkBox.isSelected();
            }

            public void restoreState() {
                checkBox.setSelected(((CodeAnalysisBeforeCheckinHandler)CodeAnalysisBeforeCheckinHandler.this).getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    private void refreshEnable(JCheckBox checkBox) {
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            checkBox.setEnabled(false);
            checkBox.setToolTipText("Code analysis is impossible until indices are up-to-date");
        } else {
            checkBox.setEnabled(true);
            checkBox.setToolTipText("");
        }
    }

    private VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    private CheckinHandler.ReturnResult processFoundCodeSmells(List<CodeSmellInfo> codeSmells, @Nullable CommitExecutor executor) {
        int answer;
        String commitButtonText;
        int errorCount = CodeAnalysisBeforeCheckinHandler.collectErrors(codeSmells);
        int warningCount = codeSmells.size() - errorCount;
        String string = commitButtonText = executor != null ? executor.getActionText() : this.myCheckinPanel.getCommitActionName();
        if (commitButtonText.endsWith("...")) {
            commitButtonText = commitButtonText.substring(0, commitButtonText.length() - 3);
        }
        if ((answer = Messages.showYesNoCancelDialog((Project)this.myProject, (String)VcsBundle.message((String)"before.commit.files.contain.code.smells.edit.them.confirm.text", (Object[])new Object[]{errorCount, warningCount}), (String)VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]), (String)VcsBundle.message((String)"code.smells.review.button", (Object[])new Object[0]), (String)commitButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)UIUtil.getWarningIcon())) == 0) {
            CodeSmellDetector.getInstance(this.myProject).showCodeSmellErrors(codeSmells);
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
        if (answer == 2) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private static int collectErrors(List<CodeSmellInfo> codeSmells) {
        int result = 0;
        for (CodeSmellInfo codeSmellInfo : codeSmells) {
            if (codeSmellInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ++result;
        }
        return result;
    }

    public CheckinHandler.ReturnResult beforeCheckin(CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        if (this.getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT) {
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)"Code analysis can't be performed while IntelliJ IDEA updates the indices in background.\nYou can commit the changes without running inspections, or you can wait until indices are built.", (String)"Code analysis is not possible right now", (String)"&Wait", (String)"&Commit", null) == 0) {
                    return CheckinHandler.ReturnResult.CANCEL;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            try {
                List<CodeSmellInfo> codeSmells = CodeSmellDetector.getInstance(this.myProject).findCodeSmells(new ArrayList<VirtualFile>(this.myCheckinPanel.getVirtualFiles()));
                if (!codeSmells.isEmpty()) {
                    return this.processFoundCodeSmells(codeSmells, executor);
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            catch (ProcessCanceledException e) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)("Code analysis failed with exception: " + e.getClass().getName() + ": " + e.getMessage()), (String)"Code analysis failed", (String)"&Commit", (String)"&Cancel", null) == 0) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                return CheckinHandler.ReturnResult.CANCEL;
            }
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }
}

