/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.actions.DeleteUnversionedFilesAction;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilesDialog
extends AbstractSelectFilesDialog<VirtualFile> {
    @NotNull
    private final VirtualFileList myFileList;
    private final boolean myDeletableFiles;

    protected SelectFilesDialog(Project project, List<VirtualFile> originalFiles, String prompt, VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        super(project, false, confirmationOption, prompt, showDoNotAskOption);
        this.myDeletableFiles = deletableFiles;
        this.myFileList = new VirtualFileList(project, originalFiles, selectableFiles, deletableFiles);
        this.myFileList.setChangesToDisplay(originalFiles);
    }

    @NotNull
    public static SelectFilesDialog init(Project project, List<VirtualFile> originalFiles, String prompt, VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        SelectFilesDialog dialog = new SelectFilesDialog(project, originalFiles, prompt, confirmationOption, selectableFiles, showDoNotAskOption, deletableFiles);
        dialog.init();
        SelectFilesDialog selectFilesDialog = dialog;
        if (selectFilesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog", "init"));
        }
        return selectFilesDialog;
    }

    public Collection<VirtualFile> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }

    public void setSelectedFiles(@NotNull Collection<VirtualFile> selected) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog", "setSelectedFiles"));
        }
        this.myFileList.setIncludedChanges(selected);
    }

    @Override
    @NotNull
    protected ChangesTreeList getFileList() {
        VirtualFileList virtualFileList = this.myFileList;
        if (virtualFileList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog", "getFileList"));
        }
        return virtualFileList;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        DefaultActionGroup defaultGroup = super.createToolbarActions();
        if (this.myDeletableFiles) {
            DeleteUnversionedFilesAction deleteAction = new DeleteUnversionedFilesAction(){

                @Override
                public void actionPerformed(AnActionEvent e) {
                    super.actionPerformed(e);
                    SelectFilesDialog.this.myFileList.refresh();
                }
            };
            defaultGroup.add((AnAction)deleteAction);
            deleteAction.registerCustomShortcutSet(CommonShortcuts.DELETE, this.getFileList());
        }
        DefaultActionGroup defaultActionGroup = defaultGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog", "createToolbarActions"));
        }
        return defaultActionGroup;
    }

    private static class VirtualFileList
    extends ChangesTreeList<VirtualFile> {
        private final Project myProject;
        @Nullable
        private final DeleteProvider myDeleteProvider;

        public VirtualFileList(Project project, List<VirtualFile> originalFiles, boolean selectableFiles, boolean deletableFiles) {
            super(project, originalFiles, selectableFiles, true, null, null);
            this.myProject = project;
            this.myDeleteProvider = deletableFiles ? new VirtualFileDeleteProvider() : null;
        }

        @Override
        protected DefaultTreeModel buildTreeModel(List<VirtualFile> changes, ChangeNodeDecorator changeNodeDecorator) {
            return new TreeModelBuilder(this.myProject, false).buildModelFromFiles(changes);
        }

        @Override
        protected List<VirtualFile> getSelectedObjects(ChangesBrowserNode node) {
            return node.getAllFilesUnder();
        }

        @Override
        protected VirtualFile getLeadSelectedObject(ChangesBrowserNode node) {
            Object o = node.getUserObject();
            if (o instanceof VirtualFile) {
                return (VirtualFile)o;
            }
            return null;
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            super.calcData(key, sink);
            if (key.equals(PlatformDataKeys.DELETE_ELEMENT_PROVIDER) && this.myDeleteProvider != null) {
                sink.put(key, (Object)this.myDeleteProvider);
            } else if (key.equals(CommonDataKeys.VIRTUAL_FILE_ARRAY)) {
                sink.put(key, (Object)ArrayUtil.toObjectArray(this.getSelectedChanges(), VirtualFile.class));
            }
        }

        public void refresh() {
            this.setChangesToDisplay(new ArrayList(Collections2.filter(this.getIncludedChanges(), (Predicate)new Predicate<VirtualFile>(){

                public boolean apply(@Nullable VirtualFile input) {
                    return input != null && input.isValid();
                }
            })));
        }
    }
}

