/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackWorker {
    private final Project myProject;
    private final String myOperationName;
    private final List<VcsException> myExceptions;

    public RollbackWorker(Project project) {
        this(project, DefaultRollbackEnvironment.ROLLBACK_OPERATION_NAME);
    }

    public RollbackWorker(Project project, String operationName) {
        this.myProject = project;
        this.myOperationName = operationName;
        this.myExceptions = new ArrayList<VcsException>(0);
    }

    public void doRollback(Collection<Change> changes, boolean deleteLocallyAddedFiles, final @Nullable Runnable afterVcsRefreshInAwt, @Nullable String localHistoryActionName) {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        final Runnable notifier = changeListManager.prepareForChangeDeletion(changes);
        Runnable afterRefresh = new Runnable(){

            @Override
            public void run() {
                changeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        notifier.run();
                        if (afterVcsRefreshInAwt != null) {
                            afterVcsRefreshInAwt.run();
                        }
                    }
                }, InvokeAfterUpdateMode.SILENT, "Refresh change lists after update", ModalityState.current());
            }
        };
        final MyRollbackRunnable rollbackAction = new MyRollbackRunnable(changes, deleteLocallyAddedFiles, afterRefresh, localHistoryActionName);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myOperationName, true, new PerformInBackgroundOption(){

                public boolean shouldStartInBackground() {
                    return VcsConfiguration.getInstance((Project)((RollbackWorker)RollbackWorker.this).myProject).PERFORM_ROLLBACK_IN_BACKGROUND;
                }

                public void processSentToBackground() {
                    VcsConfiguration.getInstance((Project)((RollbackWorker)RollbackWorker.this).myProject).PERFORM_ROLLBACK_IN_BACKGROUND = true;
                }
            }){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$3", "run"));
                    }
                    rollbackAction.run();
                }
            });
        } else {
            rollbackAction.run();
        }
        ((ChangeListManagerImpl)changeListManager).showLocalChangesInvalidated();
    }

    private class MyRollbackRunnable
    implements Runnable {
        private final Collection<Change> myChanges;
        private final boolean myDeleteLocallyAddedFiles;
        private final Runnable myAfterRefresh;
        private final String myLocalHistoryActionName;
        private ProgressIndicator myIndicator;

        private MyRollbackRunnable(Collection<Change> changes, boolean deleteLocallyAddedFiles, Runnable afterRefresh, String localHistoryActionName) {
            this.myChanges = changes;
            this.myDeleteLocallyAddedFiles = deleteLocallyAddedFiles;
            this.myAfterRefresh = afterRefresh;
            this.myLocalHistoryActionName = localHistoryActionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ChangesUtil.markInternalOperation(this.myChanges, (boolean)true);
            try {
                this.doRun();
            }
            finally {
                ChangesUtil.markInternalOperation(this.myChanges, (boolean)false);
            }
        }

        private void doRun() {
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            final ArrayList<Change> changesToRefresh = new ArrayList<Change>();
            try {
                ChangesUtil.processChangesByVcs((Project)RollbackWorker.this.myProject, this.myChanges, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(){

                    public void process(AbstractVcs vcs, List<Change> changes) {
                        RollbackEnvironment environment = vcs.getRollbackEnvironment();
                        if (environment != null) {
                            changesToRefresh.addAll(changes);
                            if (MyRollbackRunnable.this.myIndicator != null) {
                                MyRollbackRunnable.this.myIndicator.setText(vcs.getDisplayName() + ": performing " + StringUtil.toLowerCase((String)RollbackWorker.this.myOperationName) + "...");
                                MyRollbackRunnable.this.myIndicator.setIndeterminate(false);
                                MyRollbackRunnable.this.myIndicator.checkCanceled();
                            }
                            environment.rollbackChanges(changes, RollbackWorker.this.myExceptions, (RollbackProgressListener)new RollbackProgressModifier(changes.size(), MyRollbackRunnable.this.myIndicator));
                            if (MyRollbackRunnable.this.myIndicator != null) {
                                MyRollbackRunnable.this.myIndicator.setText2("");
                                MyRollbackRunnable.this.myIndicator.checkCanceled();
                            }
                            if (RollbackWorker.this.myExceptions.isEmpty() && MyRollbackRunnable.this.myDeleteLocallyAddedFiles) {
                                MyRollbackRunnable.this.deleteAddedFilesLocally(changes);
                            }
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (this.myIndicator != null) {
                this.myIndicator.startNonCancelableSection();
                this.myIndicator.setIndeterminate(true);
                this.myIndicator.setText2("");
                this.myIndicator.setText(VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
            }
            this.doRefresh(RollbackWorker.this.myProject, changesToRefresh);
            AbstractVcsHelper.getInstance((Project)RollbackWorker.this.myProject).showErrors(RollbackWorker.this.myExceptions, RollbackWorker.this.myOperationName);
        }

        private void doRefresh(final Project project, final List<Change> changesToRefresh) {
            final LocalHistoryAction action = LocalHistory.getInstance().startAction(RollbackWorker.this.myOperationName);
            Runnable forAwtThread = new Runnable(){

                @Override
                public void run() {
                    action.finish();
                    LocalHistory.getInstance().putSystemLabel(RollbackWorker.this.myProject, MyRollbackRunnable.this.myLocalHistoryActionName == null ? RollbackWorker.this.myOperationName : MyRollbackRunnable.this.myLocalHistoryActionName, -1);
                    VcsDirtyScopeManager manager = (VcsDirtyScopeManager)PeriodicalTasksCloser.getInstance().safeGetComponent(project, VcsDirtyScopeManager.class);
                    for (Change change : changesToRefresh) {
                        FilePath parent;
                        ContentRevision beforeRevision = change.getBeforeRevision();
                        ContentRevision afterRevision = change.getAfterRevision();
                        if (!change.isIsReplaced() && beforeRevision != null && Comparing.equal((Object)beforeRevision, (Object)afterRevision)) {
                            manager.fileDirty(beforeRevision.getFile());
                            continue;
                        }
                        if (beforeRevision != null && (parent = beforeRevision.getFile().getParentPath()) != null) {
                            manager.dirDirtyRecursively(parent);
                        }
                        if (afterRevision == null || (parent = afterRevision.getFile().getParentPath()) == null) continue;
                        manager.dirDirtyRecursively(parent);
                    }
                    MyRollbackRunnable.this.myAfterRefresh.run();
                }
            };
            RefreshVFsSynchronously.updateChangesForRollback(changesToRefresh);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)forAwtThread, null, (Project)project);
        }

        private void deleteAddedFilesLocally(List<Change> changes) {
            if (this.myIndicator != null) {
                this.myIndicator.setText("Deleting added files locally...");
                this.myIndicator.setFraction(0.0);
            }
            int changesSize = changes.size();
            for (int i = 0; i < changesSize; ++i) {
                Change c = changes.get(i);
                if (c.getType() != Change.Type.NEW) continue;
                ContentRevision rev = c.getAfterRevision();
                assert (rev != null);
                File ioFile = rev.getFile().getIOFile();
                if (this.myIndicator != null) {
                    this.myIndicator.setText2(ioFile.getAbsolutePath());
                    this.myIndicator.setFraction((double)i / (double)changesSize);
                }
                FileUtil.delete((File)ioFile);
            }
            if (this.myIndicator != null) {
                this.myIndicator.setText2("");
            }
        }
    }
}

