/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IgnoredSettingsPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    private JBList myList = new JBList();
    private JPanel myPanel;
    private final Project myProject;
    private DefaultListModel myModel;
    private final ChangeListManager myChangeListManager;

    public IgnoredSettingsPanel(Project project) {
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        this.myList.getEmptyText().setText(VcsBundle.message((String)"no.ignored.files", (Object[])new Object[0]));
        this.myProject = project;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    private void setItems(IgnoredFileBean[] filesToIgnore) {
        this.myModel = new DefaultListModel();
        for (IgnoredFileBean bean : filesToIgnore) {
            this.myModel.addElement(bean);
        }
        this.myList.setModel((ListModel)this.myModel);
    }

    public IgnoredFileBean[] getItems() {
        int count = this.myList.getModel().getSize();
        IgnoredFileBean[] result = new IgnoredFileBean[count];
        for (int i = 0; i < count; ++i) {
            result[i] = (IgnoredFileBean)this.myList.getModel().getElementAt(i);
        }
        return result;
    }

    private void addItem() {
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        dlg.show();
        if (dlg.isOK()) {
            IgnoredFileBean[] ignoredFiles;
            for (IgnoredFileBean bean : ignoredFiles = dlg.getSelectedIgnoredFiles()) {
                this.myModel.addElement(bean);
            }
        }
    }

    private void editItem() {
        IgnoredFileBean bean = (IgnoredFileBean)this.myList.getSelectedValue();
        if (bean == null) {
            return;
        }
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        dlg.setIgnoredFile(bean);
        dlg.show();
        if (dlg.isOK()) {
            IgnoredFileBean[] beans = dlg.getSelectedIgnoredFiles();
            assert (beans.length == 1);
            int selectedIndex = this.myList.getSelectedIndex();
            this.myModel.setElementAt(beans[0], selectedIndex);
        }
    }

    private void deleteItems() {
        boolean contigiousSelection = true;
        int minSelectionIndex = this.myList.getSelectionModel().getMinSelectionIndex();
        int maxSelectionIndex = this.myList.getSelectionModel().getMaxSelectionIndex();
        for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
            if (this.myList.getSelectionModel().isSelectedIndex(i)) continue;
            contigiousSelection = false;
            break;
        }
        if (contigiousSelection) {
            this.myModel.removeRange(minSelectionIndex, maxSelectionIndex);
        } else {
            Object[] selection;
            for (Object item : selection = this.myList.getSelectedValues()) {
                this.myModel.removeElement(item);
            }
        }
    }

    public void reset() {
        this.setItems(this.myChangeListManager.getFilesToIgnore());
    }

    public void apply() {
        this.myChangeListManager.setFilesToIgnore(this.getItems());
    }

    public boolean isModified() {
        return !Comparing.equal((Object[])this.myChangeListManager.getFilesToIgnore(), (Object[])this.getItems());
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    IgnoredSettingsPanel.this.addItem();
                }
            }).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    IgnoredSettingsPanel.this.editItem();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    IgnoredSettingsPanel.this.deleteItems();
                }
            }).disableUpDownActions().createPanel();
        }
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Ignored Files";
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Ignored.Files";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/IgnoredSettingsPanel", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer {
        private MyCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            IgnoredFileBean bean;
            String path;
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            if ((path = (bean = (IgnoredFileBean)value).getPath()) != null) {
                if (path.endsWith("/")) {
                    this.append(VcsBundle.message((String)"ignored.configure.item.directory", (Object[])new Object[]{path}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(VcsBundle.message((String)"ignored.configure.item.file", (Object[])new Object[]{path}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (bean.getMask() != null) {
                this.append(VcsBundle.message((String)"ignored.configure.item.mask", (Object[])new Object[]{bean.getMask()}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

