/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import java.util.Comparator;

public class ChangesComparator
implements Comparator<Change> {
    private static final ChangesComparator ourFlattenedInstance = new ChangesComparator(false);
    private static final ChangesComparator ourTreeInstance = new ChangesComparator(true);
    private final boolean myTreeCompare;

    public static ChangesComparator getInstance(boolean flattened) {
        if (flattened) {
            return ourFlattenedInstance;
        }
        return ourTreeInstance;
    }

    private ChangesComparator(boolean treeCompare) {
        this.myTreeCompare = treeCompare;
    }

    @Override
    public int compare(Change o1, Change o2) {
        FilePath filePath1 = ChangesUtil.getFilePath((Change)o1);
        FilePath filePath2 = ChangesUtil.getFilePath((Change)o2);
        if (this.myTreeCompare) {
            String parentPath2;
            String path1 = FileUtilRt.toSystemIndependentName((String)filePath1.getPath());
            String path2 = FileUtilRt.toSystemIndependentName((String)filePath2.getPath());
            int lastSlash1 = path1.lastIndexOf(47);
            String parentPath1 = lastSlash1 >= 0 && !filePath1.isDirectory() ? path1.substring(0, lastSlash1) : path1;
            int lastSlash2 = path2.lastIndexOf(47);
            String string = parentPath2 = lastSlash2 >= 0 && !filePath2.isDirectory() ? path2.substring(0, lastSlash2) : path2;
            if (FileUtil.isAncestor((String)parentPath2, (String)parentPath1, (boolean)true)) {
                return -1;
            }
            if (FileUtil.isAncestor((String)parentPath1, (String)parentPath2, (boolean)true)) {
                return 1;
            }
            int compare = StringUtil.compare((String)parentPath1, (String)parentPath2, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
            if (compare != 0) {
                return compare;
            }
        }
        return filePath1.getName().compareToIgnoreCase(filePath2.getName());
    }
}

