/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesCommitExecutor
extends LocalCommitExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesCommitExecutor");
    private final Project myProject;

    public ShelveChangesCommitExecutor(Project project) {
        this.myProject = project;
    }

    @Nls
    public String getActionText() {
        return VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]);
    }

    @NotNull
    public CommitSession createCommitSession() {
        ShelveChangesCommitSession shelveChangesCommitSession = new ShelveChangesCommitSession();
        if (shelveChangesCommitSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor", "createCommitSession"));
        }
        return shelveChangesCommitSession;
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.shelve";
    }

    private class ShelveChangesCommitSession
    implements CommitSession,
    CommitSessionContextAware {
        private ShelveChangesCommitSession() {
        }

        @Nullable
        public JComponent getAdditionalConfigurationUI() {
            return null;
        }

        public void setContext(CommitContext context) {
        }

        @Nullable
        public JComponent getAdditionalConfigurationUI(Collection<Change> changes, String commitMessage) {
            return null;
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage) {
            return changes.size() > 0;
        }

        public void execute(Collection<Change> changes, String commitMessage) {
            if (changes.size() > 0 && !ChangesUtil.hasFileChanges(changes)) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"shelve.changes.only.directories", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]));
                    }
                }, null, (Project)ShelveChangesCommitExecutor.this.myProject);
                return;
            }
            try {
                LocalChangeList localChangeList;
                ShelvedChangeList list = ShelveChangesManager.getInstance(ShelveChangesCommitExecutor.this.myProject).shelveChanges(changes, commitMessage, true);
                ShelvedChangesViewManager.getInstance(ShelveChangesCommitExecutor.this.myProject).activateView(list);
                Change[] changesArray = changes.toArray(new Change[changes.size()]);
                ChangeList changeList = ChangesUtil.getChangeListIfOnlyOne((Project)ShelveChangesCommitExecutor.this.myProject, (Change[])changesArray);
                if (changeList instanceof LocalChangeList && (localChangeList = (LocalChangeList)changeList).getChanges().size() == changes.size() && !localChangeList.isReadOnly() && !localChangeList.isDefault()) {
                    ChangeListManager.getInstance((Project)ShelveChangesCommitExecutor.this.myProject).removeChangeList(localChangeList.getName());
                }
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle());
                    }
                }, (ModalityState)ModalityState.NON_MODAL, (Project)ShelveChangesCommitExecutor.this.myProject);
            }
        }

        public void executionCanceled() {
        }

        public String getHelpId() {
            return null;
        }
    }
}

