/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.XmlConfigurationMerger;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcessor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfManagerConfigurationMerger
implements XmlConfigurationMerger {
    private final String myConfigPath;
    private final CompoundShelfFileProcessor myFileProcessor;

    public ShelfManagerConfigurationMerger() {
        this.myConfigPath = PathManager.getConfigPath() + "/shelf";
        this.myFileProcessor = new CompoundShelfFileProcessor("shelf");
    }

    public ShelfManagerConfigurationMerger(String configPath, @Nullable StreamProvider streamProvider) {
        this.myConfigPath = configPath;
        this.myFileProcessor = new CompoundShelfFileProcessor(streamProvider, configPath);
    }

    @NotNull
    public Element merge(Element serverElement, Element localElement) {
        Element element;
        LinkedHashMap<Date, ShelvedChangeList> result = new LinkedHashMap<Date, ShelvedChangeList>();
        Map<String, ShelvedChangeList> serverFileToChangeList = ShelfManagerConfigurationMerger.collectChanges(serverElement);
        Map<String, ShelvedChangeList> localFileToChangeList = ShelfManagerConfigurationMerger.collectChanges(localElement);
        Collection<String> serverFileNames = this.myFileProcessor.getServerFiles();
        List<String> localFileNames = this.myFileProcessor.getLocalFiles();
        HashSet<String> serverChangeListFiles = new HashSet<String>();
        for (String serverFileName : serverFileToChangeList.keySet()) {
            ShelvedChangeList localChangeList;
            ShelvedChangeList changeList = serverFileToChangeList.get(serverFileName);
            String newFileName = !localFileNames.contains(serverFileName) ? this.myFileProcessor.copyFileFromServer(serverFileName, localFileNames) : ((localChangeList = localFileToChangeList.get(serverFileName)) != null && localChangeList.DATE.equals(changeList.DATE) ? this.myFileProcessor.copyFileFromServer(serverFileName, localFileNames) : this.myFileProcessor.renameFileOnServer(serverFileName, serverFileNames, localFileNames));
            changeList.PATH = new File(this.myFileProcessor.getBaseIODir(), newFileName).getAbsolutePath();
            serverChangeListFiles.add(newFileName);
            result.put(changeList.DATE, changeList);
        }
        for (ShelvedChangeList changeList : localFileToChangeList.values()) {
            result.put(changeList.DATE, changeList);
            serverChangeListFiles.remove(new File(changeList.PATH).getName());
        }
        Collection<ShelvedChangeList> resultChanges = result.values();
        for (ShelvedChangeList resultChange : resultChanges) {
            String patchFileName = new File(resultChange.PATH).getName();
            resultChange.PATH = this.myConfigPath + "/" + patchFileName;
            if (!serverChangeListFiles.contains(patchFileName)) continue;
            for (ShelvedBinaryFile binaryFile : resultChange.getBinaryFiles()) {
                assert (binaryFile.SHELVED_PATH != null);
                String binFileName = new File(binaryFile.SHELVED_PATH).getName();
                String newBinFileName = localFileNames.contains(binFileName) ? this.myFileProcessor.renameFileOnServer(binFileName, serverFileNames, localFileNames) : this.myFileProcessor.copyFileFromServer(binFileName, localFileNames);
                binaryFile.SHELVED_PATH = new File(this.myFileProcessor.getBaseIODir(), newBinFileName).getAbsolutePath();
            }
        }
        Collection<ShelvedChangeList> changes = ShelfManagerConfigurationMerger.extractChanges(resultChanges, false);
        Collection<ShelvedChangeList> recycled = ShelfManagerConfigurationMerger.extractChanges(resultChanges, true);
        try {
            Element resultElement = new Element(localElement.getName());
            Iterator<Object> i$ = localElement.getAttributes().iterator();
            while (i$.hasNext()) {
                Attribute attrObject;
                Attribute attr = attrObject = (Attribute)i$.next();
                resultElement.setAttribute(attr.getName(), attr.getValue());
            }
            ShelvedChangeList.writeChanges(changes, recycled, resultElement);
            element = resultElement;
        }
        catch (WriteExternalException e) {
            Element element2 = serverElement;
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelfManagerConfigurationMerger", "merge"));
            }
            return element2;
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelfManagerConfigurationMerger", "merge"));
        }
        return element;
    }

    private static Collection<ShelvedChangeList> extractChanges(Collection<ShelvedChangeList> changes, boolean recycled) {
        ArrayList<ShelvedChangeList> result = new ArrayList<ShelvedChangeList>();
        for (ShelvedChangeList change : changes) {
            if (change.isRecycled() != recycled) continue;
            result.add(change);
        }
        return result;
    }

    private static Map<String, ShelvedChangeList> collectChanges(Element original) {
        HashMap<String, ShelvedChangeList> result = new HashMap<String, ShelvedChangeList>();
        try {
            for (ShelvedChangeList shelvedChangeList : ShelvedChangeList.readChanges(original, true, false)) {
                result.put(new File(shelvedChangeList.PATH).getName(), shelvedChangeList);
            }
            for (ShelvedChangeList shelvedChangeList : ShelvedChangeList.readChanges(original, false, false)) {
                result.put(new File(shelvedChangeList.PATH).getName(), shelvedChangeList);
            }
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return result;
    }

    public String getComponentName() {
        return "ShelveChangesManager";
    }
}

