/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import java.io.File;

public class PatchNameChecker {
    public static final int MAX = 100;
    private final String myName;
    private boolean myPreventsOk;
    private String myError;
    private final String myPath;

    public PatchNameChecker(String name) {
        this.myPath = name;
        this.myName = new File(name).getName();
        this.myPreventsOk = false;
    }

    public boolean nameOk() {
        if (this.myName == null || this.myName.length() == 0) {
            this.myError = "File name cannot be empty";
            this.myPreventsOk = true;
            return false;
        }
        if (this.myName.length() > 100) {
            this.myError = "File name length cannot exceed 100 characters";
            this.myPreventsOk = true;
            return false;
        }
        if (new File(this.myPath).exists()) {
            this.myError = "File with the same name already exists";
            this.myPreventsOk = false;
            return false;
        }
        return true;
    }

    public boolean isPreventsOk() {
        return this.myPreventsOk;
    }

    public String getError() {
        return this.myError;
    }
}

