/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;

public class MergedDiffRequestPresentable
implements DiffRequestPresentable {
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myAfterTitle;
    private final Getter<ApplyPatchForBaseRevisionTexts> myTexts;

    public MergedDiffRequestPresentable(Project project, Getter<ApplyPatchForBaseRevisionTexts> texts, VirtualFile file, String afterTitle) {
        this.myTexts = texts;
        this.myProject = project;
        this.myFile = file;
        this.myAfterTitle = afterTitle;
    }

    public DiffRequestPresentable.MyResult step(DiffChainContext context) {
        boolean nowItIsText;
        FilePathImpl filePath = new FilePathImpl(this.myFile);
        if (filePath.getFileType().isBinary() && !(nowItIsText = ChangeDiffRequestPresentable.checkAssociate(this.myProject, filePath, context))) {
            SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
            return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.removeFromList);
        }
        ApplyPatchForBaseRevisionTexts revisionTexts = (ApplyPatchForBaseRevisionTexts)this.myTexts.get();
        if (revisionTexts.getBase() == null) {
            SimpleDiffRequest badDiffRequest = ApplyPatchAction.createBadDiffRequest(this.myProject, this.myFile, revisionTexts, true);
            return new DiffRequestPresentable.MyResult((DiffRequest)badDiffRequest, DiffPresentationReturnValue.useRequest);
        }
        MergeRequest request = DiffRequestFactory.getInstance().create3WayDiffRequest(((Object)revisionTexts.getLocal()).toString(), revisionTexts.getPatched(), ((Object)revisionTexts.getBase()).toString(), this.myProject, null, null);
        request.setWindowTitle(VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{FileUtil.toSystemDependentName((String)this.myFile.getPresentableUrl())}));
        request.setVersionTitles(new String[]{"Current Version", "Base Version", FileUtil.toSystemDependentName((String)this.myAfterTitle)});
        return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.useRequest);
    }

    public String getPathPresentation() {
        return this.myFile.getPath();
    }

    public void haveStuff() {
    }

    public List<? extends AnAction> createActions(DiffExtendUIFactory uiFactory) {
        return Collections.emptyList();
    }
}

