/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SimiliarListsZipper {
    private final LinkedList<SubSequence<CommittedChangeList>> myLists;
    private final List<CommittedChangeList> myResult;
    private final VcsCommittedListsZipper myZipper;
    private final RepositoryLocationGroup myGroup;

    public SimiliarListsZipper(Collection<List<CommittedChangeList>> lists, VcsCommittedListsZipper zipper, RepositoryLocationGroup group) {
        this.myZipper = zipper;
        this.myGroup = group;
        this.myLists = new LinkedList();
        this.myResult = new ArrayList<CommittedChangeList>();
        for (List<CommittedChangeList> list : lists) {
            if (list.isEmpty()) continue;
            this.myLists.add(new SubSequence(list));
        }
    }

    public void zip() {
        Collections.sort(this.myLists);
        while (!this.myLists.isEmpty() && (this.tryZipFirstN() || this.usualStep())) {
        }
    }

    private boolean usualStep() {
        while (!this.myLists.isEmpty()) {
            SubSequence<CommittedChangeList> sequence = this.myLists.removeFirst();
            this.myResult.add(sequence.getCurrentList());
            if (!sequence.hasNext()) continue;
            sequence.next();
            this.insert(sequence);
            return true;
        }
        return false;
    }

    private boolean tryZipFirstN() {
        SubSequence<CommittedChangeList> sequence;
        SubSequence<CommittedChangeList> firstSequence = this.myLists.getFirst();
        ArrayList<SubSequence<CommittedChangeList>> removed = null;
        ArrayList<CommittedChangeList> toBeZipped = null;
        ListIterator<SubSequence<CommittedChangeList>> iterator = this.myLists.listIterator(1);
        while (iterator.hasNext() && (sequence = iterator.next()).compareTo(firstSequence) == 0) {
            if (removed == null) {
                removed = new ArrayList<SubSequence<CommittedChangeList>>();
                toBeZipped = new ArrayList<CommittedChangeList>();
            }
            iterator.remove();
            removed.add(sequence);
            toBeZipped.add(sequence.getCurrentList());
        }
        if (removed != null) {
            this.myLists.removeFirst();
            removed.add(firstSequence);
            toBeZipped.add(firstSequence.getCurrentList());
            CommittedChangeList zippedList = this.myZipper.zip(this.myGroup, toBeZipped);
            this.myResult.add(zippedList);
            for (SubSequence subSequence : removed) {
                if (!subSequence.hasNext()) continue;
                subSequence.next();
                this.insert(subSequence);
            }
            return true;
        }
        return false;
    }

    private void insert(SubSequence<CommittedChangeList> firstSequence) {
        ListIterator<SubSequence<CommittedChangeList>> iterator = this.myLists.listIterator();
        while (iterator.hasNext()) {
            SubSequence currentSequence = (SubSequence)iterator.next();
            if (currentSequence.compareTo(firstSequence) <= 0) continue;
            iterator.previous();
            iterator.add(firstSequence);
            return;
        }
        this.myLists.addLast(firstSequence);
    }

    public List<CommittedChangeList> getResult() {
        return this.myResult;
    }

    private class SubSequence<T extends CommittedChangeList>
    implements Comparable<SubSequence<T>> {
        private int myIdx;
        private long myCachedNumber;
        private final List<T> myList;

        private SubSequence(List<T> list) {
            this.myList = list;
            this.myIdx = 0;
            this.myCachedNumber = SimiliarListsZipper.this.myZipper.getNumber((CommittedChangeList)this.myList.get(0));
        }

        boolean hasNext() {
            return this.myIdx < this.myList.size() - 1;
        }

        @Override
        public int compareTo(SubSequence<T> other) {
            long sign = this.myCachedNumber - other.myCachedNumber;
            return sign == 0L ? 0 : (sign < 0L ? -1 : 1);
        }

        void next() {
            if (this.hasNext()) {
                ++this.myIdx;
                this.myCachedNumber = SimiliarListsZipper.this.myZipper.getNumber((CommittedChangeList)this.myList.get(this.myIdx));
            }
        }

        T getCurrentList() {
            return (T)((CommittedChangeList)this.myList.get(this.myIdx));
        }
    }
}

