/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.SelectedFilesHelper;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MoveChangesToAnotherListAction
extends AnAction
implements DumbAware {
    public MoveChangesToAnotherListAction() {
        super(ActionsBundle.actionText((String)"ChangesView.Move"), ActionsBundle.actionDescription((String)"ChangesView.Move"), AllIcons.Actions.MoveToAnotherChangelist);
    }

    public void update(AnActionEvent e) {
        boolean isEnabled = MoveChangesToAnotherListAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return false;
        }
        List unversionedFiles = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            return true;
        }
        boolean hasChangedOrUnversionedFiles = SelectedFilesHelper.hasChangedOrUnversionedFiles(project, e);
        if (hasChangedOrUnversionedFiles) {
            return true;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes != null && changes.length > 0) {
            return true;
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return files != null && files.length > 0;
    }

    @Nullable
    private static List<Change> getChangesForSelectedFiles(Project project, List<VirtualFile> unversionedFiles, @Nullable List<VirtualFile> changedFiles, AnActionEvent e) {
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length == 0) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null) {
            ArrayList<Change> changesInFiles = new ArrayList<Change>();
            for (VirtualFile vFile : virtualFiles) {
                Change change = changeListManager.getChange(vFile);
                if (change == null) {
                    FileStatus status = changeListManager.getStatus(vFile);
                    if (FileStatus.UNKNOWN.equals(status)) {
                        unversionedFiles.add(vFile);
                        if (changedFiles == null) continue;
                        changedFiles.add(vFile);
                        continue;
                    }
                    if (!FileStatus.NOT_CHANGED.equals(status) || !vFile.isDirectory()) continue;
                    MoveChangesToAnotherListAction.addAllChangesUnderPath(changedFiles, changeListManager, changesInFiles, new FilePathImpl(vFile));
                    continue;
                }
                if (change.getAfterRevision() != null && change.getAfterRevision().getFile() != null && change.getAfterRevision().getFile().isDirectory()) {
                    FilePath file = change.getAfterRevision().getFile();
                    MoveChangesToAnotherListAction.addAllChangesUnderPath(changedFiles, changeListManager, changesInFiles, file);
                    continue;
                }
                changesInFiles.add(change);
                if (changedFiles == null) continue;
                changedFiles.add(vFile);
            }
            return changesInFiles;
        }
        return Collections.emptyList();
    }

    private static void addAllChangesUnderPath(List<VirtualFile> changedFiles, ChangeListManager changeListManager, List<Change> changesInFiles, FilePath file) {
        Collection in = changeListManager.getChangesIn(file);
        changesInFiles.addAll(in);
        if (changedFiles != null) {
            for (Change innerChange : in) {
                FilePath path = ChangesUtil.getAfterPath((Change)innerChange);
                if (path == null || path.getVirtualFile() == null) continue;
                changedFiles.add(path.getVirtualFile());
            }
        }
    }

    public void actionPerformed(AnActionEvent e) {
        ToolWindow window;
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        ArrayList<VirtualFile> unversionedFiles = (ArrayList<VirtualFile>)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        final ArrayList<VirtualFile> changedFiles = new ArrayList<VirtualFile>();
        boolean activateChangesView = false;
        unversionedFiles = new ArrayList<VirtualFile>();
        ArrayList<Change> changesList = new ArrayList<Change>();
        if (changes != null) {
            changesList.addAll(Arrays.asList(changes));
        } else {
            changes = new Change[]{};
        }
        changesList.addAll(MoveChangesToAnotherListAction.getChangesForSelectedFiles(project, unversionedFiles, changedFiles, e));
        activateChangesView = true;
        if (changesList.isEmpty() && unversionedFiles.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Nothing is selected that can be moved", MessageType.INFO, new NamedRunnable[0]);
            return;
        }
        if (!MoveChangesToAnotherListAction.askAndMove(project, changesList, unversionedFiles)) {
            return;
        }
        if (activateChangesView && !(window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID)).isVisible()) {
            window.activate(new Runnable(){

                @Override
                public void run() {
                    if (changedFiles.size() > 0) {
                        ChangesViewManager.getInstance(project).selectFile((VirtualFile)changedFiles.get(0));
                    }
                }
            });
        }
    }

    public static boolean askAndMove(Project project, Collection<Change> changes, List<VirtualFile> unversionedFiles) {
        if (changes.isEmpty() && unversionedFiles.isEmpty()) {
            return false;
        }
        ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<LocalChangeList> lists = listManager.getChangeLists();
        List<LocalChangeList> preferredLists = MoveChangesToAnotherListAction.getPreferredLists(lists, changes, true);
        ChangeListChooser chooser = new ChangeListChooser(project, preferredLists, MoveChangesToAnotherListAction.guessPreferredList(preferredLists), ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]), null);
        chooser.show();
        LocalChangeList resultList = chooser.getSelectedList();
        if (resultList != null) {
            listManager.moveChangesTo(resultList, changes.toArray(new Change[changes.size()]));
            if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
                listManager.addUnversionedFiles(resultList, unversionedFiles);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static ChangeList guessPreferredList(List<LocalChangeList> preferredLists) {
        for (LocalChangeList preferredList : preferredLists) {
            if (!preferredList.getChanges().isEmpty()) continue;
            return preferredList;
        }
        if (preferredLists.size() > 0) {
            return (ChangeList)preferredLists.get(0);
        }
        return null;
    }

    private static List<LocalChangeList> getPreferredLists(List<LocalChangeList> lists, Collection<Change> changes, boolean includeDefaultIfEmpty) {
        ArrayList<LocalChangeList> preferredLists = new ArrayList<LocalChangeList>(lists);
        THashSet changesAsSet = new THashSet(changes);
        block0: for (LocalChangeList list : lists) {
            for (Change change : list.getChanges()) {
                if (!changesAsSet.contains(change)) continue;
                preferredLists.remove(list);
                continue block0;
            }
        }
        if (preferredLists.isEmpty() && includeDefaultIfEmpty) {
            for (LocalChangeList list : lists) {
                if (!list.isDefault()) continue;
                preferredLists.add(list);
            }
        }
        return preferredLists;
    }
}

