/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;

public class BrowseChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        assert (vFile != null);
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(vFile);
        assert (vcs != null);
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        assert (provider != null);
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        CommittedChangesFilterDialog dlg = new CommittedChangesFilterDialog(project, provider.createFilterUI(true), settings);
        dlg.show();
        if (!dlg.isOK()) {
            return;
        }
        int maxCount = 0;
        if (!settings.isAnyFilterSpecified()) {
            int rc = Messages.showYesNoCancelDialog((Project)project, (String)VcsBundle.message((String)"browse.changes.no.filter.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.recent.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.all.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (rc == 2) {
                return;
            }
            if (rc == 0) {
                maxCount = 50;
            }
        }
        AbstractVcsHelper.getInstance((Project)project).openCommittedChangesTab(vcs, vFile, settings, maxCount, null);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(BrowseChangesAction.isActionEnabled(e));
    }

    private static boolean isActionEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (vFile == null) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(vFile);
        if (vcs == null || vcs.getCommittedChangesProvider() == null || !vcs.allowsRemoteCalls(vFile)) {
            return false;
        }
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(vFile);
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }
}

