/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.BinaryDiffTool;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.AbstractRefreshablePanel;
import com.intellij.openapi.vcs.changes.BinaryDiffRequestFromChange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesFragmentedDiffPanel;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.FragmentedDiffRequestFromChange;
import com.intellij.openapi.vcs.changes.PreparedFragmentedContent;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.TabbedRefreshablePanel;
import com.intellij.openapi.vcs.changes.ValueWithVcsException;
import com.intellij.openapi.vcs.changes.VcsChangeDetailsProvider;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.BeforeAfter;
import com.intellij.vcsUtil.UIVcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class VcsChangeDetailsManager {
    private final List<VcsChangeDetailsProvider> myProviders = new ArrayList<VcsChangeDetailsProvider>();
    private final List<VcsChangeDetailsProvider> myDedicatedList;
    private final Project myProject;
    private final BackgroundTaskQueue myQueue;

    public VcsChangeDetailsManager(Project project) {
        this.myProject = project;
        this.myQueue = new BackgroundTaskQueue(this.myProject, "Loading change details");
        this.myDedicatedList = new ArrayList<VcsChangeDetailsProvider>();
        this.myDedicatedList.add(new BinaryDetailsProviderNew(project));
        this.myDedicatedList.add(new FragmentedDiffDetailsProvider(this.myProject));
        VcsChangeDetailsProvider[] extensions = (VcsChangeDetailsProvider[])Extensions.getExtensions(VcsChangeDetailsProvider.EP_NAME, (AreaInstance)this.myProject);
        this.myProviders.addAll(Arrays.asList(extensions));
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                VcsChangeDetailsManager.this.myQueue.clear();
            }
        });
    }

    public boolean canComment(Change change) {
        for (VcsChangeDetailsProvider provider : this.myDedicatedList) {
            if (!provider.canComment(change)) continue;
            return true;
        }
        for (VcsChangeDetailsProvider provider : this.myProviders) {
            if (!provider.canComment(change)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RefreshablePanel getPanel(Change change, JComponent parent) {
        ArrayList<Pair> panels = new ArrayList<Pair>();
        for (VcsChangeDetailsProvider convertor : this.myDedicatedList) {
            RefreshablePanel refreshablePanel;
            if (!convertor.canComment(change) || (refreshablePanel = convertor.comment(change, parent, this.myQueue)) == null) continue;
            panels.add(new Pair((Object)"Diff", (Object)refreshablePanel));
            break;
        }
        for (VcsChangeDetailsProvider provider : this.myProviders) {
            RefreshablePanel refreshablePanel;
            if (!provider.canComment(change) || (refreshablePanel = provider.comment(change, parent, this.myQueue)) == null) continue;
            panels.add(new Pair((Object)provider.getName(), (Object)refreshablePanel));
        }
        if (!panels.isEmpty()) {
            if (panels.size() == 1) {
                return (RefreshablePanel)((Pair)panels.get(0)).getSecond();
            }
            TabbedRefreshablePanel tabbedRefreshablePanel = new TabbedRefreshablePanel();
            for (Pair pair : panels) {
                tabbedRefreshablePanel.addTab((String)pair.getFirst(), (RefreshablePanel)pair.getSecond());
            }
            return tabbedRefreshablePanel;
        }
        return null;
    }

    public static VcsChangeDetailsManager getInstance(Project project) {
        return (VcsChangeDetailsManager)ServiceManager.getService((Project)project, VcsChangeDetailsManager.class);
    }

    private static boolean canBeShownInBinaryDiff(Change change, Project project) {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        if (path != null && path.isDirectory()) {
            return false;
        }
        if (change.isTreeConflict() || change.isPhantom()) {
            return false;
        }
        return ShowDiffAction.isBinaryChangeAndCanShow(project, change);
    }

    private static JPanel noDifferences() {
        return UIVcsUtil.errorPanel((String)DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.or.whitespaces", (Object[])new Object[0]), (boolean)false);
    }

    private static String changeDescription(Change o) {
        return ChangesUtil.getFilePath((Change)o).getName() + " (" + (o.getBeforeRevision() == null ? "New" : VcsChangeDetailsManager.beforeRevisionText(o)) + ")";
    }

    private static String beforeRevisionText(Change o) {
        VcsRevisionNumber revisionNumber = o.getBeforeRevision().getRevisionNumber();
        return revisionNumber instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revisionNumber).toShortString() : revisionNumber.asString();
    }

    private static class FragmentedDiffDetailsPanel
    extends AbstractRefreshablePanel<ValueWithVcsException<PreparedFragmentedContent>> {
        private final FragmentedDiffRequestFromChange myRequestFromChange;
        private final FilePath myFilePath;
        private final ChangeListManager myChangeListManager;
        private final ChangesFragmentedDiffPanel myDiffPanel;
        private final Project myProject;

        private FragmentedDiffDetailsPanel(Project project, BackgroundTaskQueue queue, Change change, JComponent parent) {
            super(project, "Loading change content", queue);
            this.myProject = project;
            this.myFilePath = ChangesUtil.getFilePath((Change)change);
            this.myRequestFromChange = new FragmentedDiffRequestFromChange(project);
            this.myChangeListManager = ChangeListManager.getInstance((Project)project);
            this.myDiffPanel = new ChangesFragmentedDiffPanel(project, VcsChangeDetailsManager.changeDescription(change), parent);
            this.myDiffPanel.buildUi();
        }

        @Override
        protected void refreshPresentation() {
            this.myDiffPanel.refreshPresentation();
        }

        @Override
        public boolean isStillValid(Change data) {
            return FragmentedDiffRequestFromChange.canCreateRequest(data);
        }

        @Override
        protected ValueWithVcsException<PreparedFragmentedContent> loadImpl() throws VcsException {
            return new ValueWithVcsException<PreparedFragmentedContent>(){

                @Override
                protected PreparedFragmentedContent computeImpl() throws VcsException {
                    Change change = FragmentedDiffDetailsPanel.this.myChangeListManager.getChange(FragmentedDiffDetailsPanel.this.myFilePath);
                    if (change == null) {
                        return null;
                    }
                    FragmentedDiffDetailsPanel.this.myDiffPanel.setTitle(VcsChangeDetailsManager.changeDescription(change));
                    return FragmentedDiffDetailsPanel.this.myRequestFromChange.getRanges(change);
                }
            };
        }

        @Override
        protected JPanel dataToPresentation(ValueWithVcsException<PreparedFragmentedContent> value) {
            PreparedFragmentedContent requestForChange;
            try {
                if (value == null) {
                    return VcsChangeDetailsManager.noDifferences();
                }
                requestForChange = (PreparedFragmentedContent)value.get();
                if (requestForChange == null) {
                    return VcsChangeDetailsManager.noDifferences();
                }
                if (requestForChange.isEmpty()) {
                    return VcsChangeDetailsManager.noDifferences();
                }
            }
            catch (VcsException e) {
                return UIVcsUtil.errorPanel((String)e.getMessage(), (boolean)true);
            }
            this.myDiffPanel.refreshData(requestForChange);
            return this.myDiffPanel.getPanel();
        }

        @Override
        protected void disposeImpl() {
            Disposer.dispose((Disposable)this.myDiffPanel);
        }

        @Override
        public boolean refreshDataSynch() {
            try {
                this.myTicket.increment();
                ValueWithVcsException<PreparedFragmentedContent> exception = this.loadImpl();
                this.dataToPresentation(exception);
            }
            catch (VcsException e) {
                return false;
            }
            return true;
        }

        @Override
        public void away() {
            this.myDiffPanel.away();
        }
    }

    private static class FragmentedDiffDetailsProvider
    implements VcsChangeDetailsProvider {
        private final Project myProject;

        private FragmentedDiffDetailsProvider(Project project) {
            this.myProject = project;
        }

        @Override
        public String getName() {
            return "Contents Diff";
        }

        @Override
        public boolean canComment(Change change) {
            return FragmentedDiffRequestFromChange.canCreateRequest(change);
        }

        @Override
        public RefreshablePanel comment(Change change, JComponent parent, BackgroundTaskQueue queue) {
            return new FragmentedDiffDetailsPanel(this.myProject, queue, change, parent);
        }
    }

    private static class BinaryDiffDetailsPanel
    extends AbstractRefreshablePanel<ValueWithVcsException<List<BeforeAfter<DiffContent>>>> {
        private final BinaryDiffRequestFromChange myRequestFromChange;
        private final Project myProject;
        private final ChangeListManager myChangeListManager;
        private final FilePath myFilePath;
        private Change myChange;
        private final DiffPanel myPanel;

        private BinaryDiffDetailsPanel(Project project, BackgroundTaskQueue queue, Change change) {
            super(project, "Loading change content", queue);
            this.myProject = project;
            this.myFilePath = ChangesUtil.getFilePath((Change)change);
            this.myRequestFromChange = new BinaryDiffRequestFromChange(this.myProject);
            this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
            this.myPanel = DiffManager.getInstance().createDiffPanel(null, this.myProject, (Disposable)this, BinaryDiffTool.INSTANCE);
            this.myPanel.enableToolbar(false);
            this.myPanel.removeStatusBar();
            DiffPanelOptions o = ((DiffPanelEx)this.myPanel).getOptions();
            o.setRequestFocusOnNewContent(false);
        }

        @Override
        public boolean isStillValid(Change data) {
            return VcsChangeDetailsManager.canBeShownInBinaryDiff(data, this.myProject);
        }

        @Override
        protected void refreshPresentation() {
        }

        @Override
        protected ValueWithVcsException<List<BeforeAfter<DiffContent>>> loadImpl() throws VcsException {
            this.myChange = this.myChangeListManager.getChange(this.myFilePath);
            if (this.myChange == null) {
                return null;
            }
            return new ValueWithVcsException<List<BeforeAfter<DiffContent>>>(){

                @Override
                protected List<BeforeAfter<DiffContent>> computeImpl() throws VcsException {
                    return BinaryDiffDetailsPanel.this.myRequestFromChange.createRequestForChange(BinaryDiffDetailsPanel.this.myChange, 0);
                }
            };
        }

        @Override
        protected JPanel dataToPresentation(ValueWithVcsException<List<BeforeAfter<DiffContent>>> value) {
            List contents;
            if (value == null) {
                return VcsChangeDetailsManager.noDifferences();
            }
            try {
                contents = (List)value.get();
                if (contents == null) {
                    throw new VcsException("Can not load content");
                }
                if (BinaryDiffDetailsPanel.isUnknownType(contents)) {
                    return UIVcsUtil.errorPanel((String)DiffBundle.message((String)"diff.can.not.show.unknown", (Object[])new Object[0]), (boolean)false);
                }
                if (this.isEmpty(contents)) {
                    throw new VcsException("Can not load content");
                }
            }
            catch (VcsException e) {
                return UIVcsUtil.errorPanel((String)e.getMessage(), (boolean)true);
            }
            if (contents.isEmpty()) {
                return VcsChangeDetailsManager.noDifferences();
            }
            assert (contents.size() == 1);
            this.myPanel.setContents((DiffContent)((BeforeAfter)contents.get(0)).getBefore(), (DiffContent)((BeforeAfter)contents.get(0)).getAfter());
            ((DiffPanelImpl)this.myPanel).getOptions().setRequestFocusOnNewContent(false);
            JPanel wholeWrapper = new JPanel(new BorderLayout());
            JPanel topPanel = new JPanel(new BorderLayout());
            JPanel wrapper = new JPanel();
            BoxLayout boxLayout = new BoxLayout(wrapper, 0);
            wrapper.setLayout(boxLayout);
            JLabel label = new JLabel(VcsChangeDetailsManager.changeDescription(this.myChange));
            label.setBorder(BorderFactory.createEmptyBorder(1, 2, 0, 0));
            wrapper.add(label);
            topPanel.add((Component)wrapper, "Center");
            wholeWrapper.add((Component)topPanel, "North");
            wholeWrapper.add((Component)this.myPanel.getComponent(), "Center");
            return wholeWrapper;
        }

        private static boolean isUnknownType(List<BeforeAfter<DiffContent>> contents) {
            for (BeforeAfter<DiffContent> content : contents) {
                if (!DiffUtil.oneIsUnknown((DiffContent)content.getBefore(), (DiffContent)content.getAfter())) continue;
                return true;
            }
            return false;
        }

        private boolean isEmpty(List<BeforeAfter<DiffContent>> contents) {
            for (BeforeAfter<DiffContent> content : contents) {
                if (this.contentIsEmpty((DiffContent)content.getAfter()) && this.contentIsEmpty((DiffContent)content.getBefore())) continue;
                return false;
            }
            return true;
        }

        private boolean contentIsEmpty(DiffContent content) {
            return content != null && content.isEmpty();
        }

        @Override
        protected void disposeImpl() {
        }

        @Override
        public void away() {
        }
    }

    private static class BinaryDetailsProviderNew
    implements VcsChangeDetailsProvider {
        private final Project myProject;

        private BinaryDetailsProviderNew(Project project) {
            this.myProject = project;
        }

        @Override
        public String getName() {
            return "Contents Diff";
        }

        @Override
        public boolean canComment(Change change) {
            return VcsChangeDetailsManager.canBeShownInBinaryDiff(change, this.myProject);
        }

        @Override
        public RefreshablePanel comment(Change change, JComponent parent, BackgroundTaskQueue queue) {
            return new BinaryDiffDetailsPanel(this.myProject, queue, change);
        }
    }
}

