/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PsiChangeTracker {
    private PsiChangeTracker() {
    }

    public static <T extends PsiElement> Map<T, FileStatus> getElementsChanged(PsiFile file, PsiFilter<T> filter) {
        Project project = file.getProject();
        VirtualFile vf = file.getVirtualFile();
        if (vf == null) {
            return Collections.emptyMap();
        }
        String oldText = PsiChangeTracker.getUnmodifiedDocument(vf, project);
        PsiFile oldFile = oldText == null ? null : PsiFileFactory.getInstance((Project)project).createFileFromText((CharSequence)oldText, file);
        return PsiChangeTracker.getElementsChanged((PsiElement)file, (PsiElement)oldFile, filter);
    }

    public static <T extends PsiElement> Map<T, FileStatus> getElementsChanged(PsiElement file, PsiElement oldFile, PsiFilter<T> filter) {
        FileStatus status;
        HashMap<PsiElement, FileStatus> result = new HashMap<PsiElement, FileStatus>();
        ArrayList oldElements = new ArrayList();
        ArrayList elements = new ArrayList();
        if (file == null) {
            oldFile.accept((PsiElementVisitor)filter.createVisitor(oldElements));
            PsiChangeTracker.calculateStatuses(elements, oldElements, result, filter);
            return result;
        }
        Project project = file.getProject();
        file.accept((PsiElementVisitor)filter.createVisitor(elements));
        VirtualFile vf = file.getContainingFile().getVirtualFile();
        FileStatus fileStatus = status = vf == null ? null : FileStatusManager.getInstance((Project)project).getStatus(vf);
        if (status == null && oldFile == null) {
            status = FileStatus.ADDED;
        }
        if (status == FileStatus.ADDED || status == FileStatus.DELETED || status == FileStatus.DELETED_FROM_FS || status == FileStatus.UNKNOWN) {
            for (PsiElement element : elements) {
                result.put(element, status);
            }
            return result;
        }
        if (oldFile == null) {
            return result;
        }
        oldFile.accept((PsiElementVisitor)filter.createVisitor(oldElements));
        PsiChangeTracker.calculateStatuses(elements, oldElements, result, filter);
        return result;
    }

    private static <T extends PsiElement> Map<T, FileStatus> calculateStatuses(List<T> elements, List<T> oldElements, Map<T, FileStatus> result, PsiFilter<T> filter) {
        for (PsiElement element : elements) {
            PsiElement e = null;
            for (PsiElement oldElement : oldElements) {
                if (!filter.areEquivalent(element, oldElement)) continue;
                e = oldElement;
                break;
            }
            if (e != null) {
                oldElements.remove(e);
                if (element.getText().equals(e.getText())) continue;
                result.put(element, FileStatus.MODIFIED);
                continue;
            }
            result.put(element, FileStatus.ADDED);
        }
        for (PsiElement oldElement : oldElements) {
            result.put(oldElement, FileStatus.DELETED);
        }
        return result;
    }

    @Nullable
    private static String getUnmodifiedDocument(final VirtualFile file, Project project) {
        Change change = ChangeListManager.getInstance((Project)project).getChange(file);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision instanceof BinaryContentRevision) {
                return null;
            }
            if (beforeRevision != null) {
                String content;
                try {
                    content = beforeRevision.getContent();
                }
                catch (VcsException ex) {
                    content = null;
                }
                return content == null ? null : StringUtil.convertLineSeparators((String)content);
            }
            return null;
        }
        if (FileDocumentManager.getInstance().isFileModified(file)) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return ((Object)LoadTextUtil.loadText(file)).toString();
                }
            });
        }
        return null;
    }
}

