/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.AbstractIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;

public class MapIgnoredFilesHolder
extends AbstractIgnoredFilesHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.MapIgnoredFilesHolder");
    private final Set<VirtualFile> mySet;
    private final Set<VirtualFile> myVcsIgnoredSet;
    private final Project myProject;

    public MapIgnoredFilesHolder(Project project) {
        super(project);
        this.myProject = project;
        this.mySet = new HashSet();
        this.myVcsIgnoredSet = new HashSet();
    }

    @Override
    protected void removeFile(VirtualFile file) {
        this.mySet.remove(file);
        this.myVcsIgnoredSet.remove(file);
    }

    @Override
    protected Collection<VirtualFile> keys() {
        return this.mySet;
    }

    @Override
    public void addFile(VirtualFile file) {
        this.mySet.add(file);
    }

    public void addByVcsChangeProvider(VirtualFile file) {
        this.myVcsIgnoredSet.add(file);
    }

    @Override
    public boolean containsFile(VirtualFile file) {
        return this.mySet.contains(file) || this.myVcsIgnoredSet.contains(file);
    }

    @Override
    public Collection<VirtualFile> values() {
        return ContainerUtil.union(this.mySet, this.myVcsIgnoredSet);
    }

    @Override
    public void cleanAll() {
        this.mySet.clear();
        this.myVcsIgnoredSet.clear();
    }

    @Override
    public FileHolder copy() {
        MapIgnoredFilesHolder result = new MapIgnoredFilesHolder(this.myProject);
        result.mySet.addAll(this.mySet);
        result.myVcsIgnoredSet.addAll(this.myVcsIgnoredSet);
        return result;
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs scope) {
    }
}

