/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.util.containers.Convertor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LineNumberConvertor
implements Convertor<Integer, Integer> {
    private final TreeMap<Integer, Integer> myFragmentStarts = new TreeMap();
    private final Set<Integer> myEmptyLines = new HashSet<Integer>();

    public void put(int start, int offset) {
        this.myFragmentStarts.put(start, offset);
    }

    public void emptyLine(int line) {
        this.myEmptyLines.add(line);
    }

    public Integer convert(Integer o) {
        if (this.myEmptyLines.contains(o)) {
            return -1;
        }
        Map.Entry<Integer, Integer> floor = this.myFragmentStarts.floorEntry(o);
        return floor == null ? o : floor.getValue() + o - floor.getKey();
    }
}

