/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastUnchangedContentTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.LastUnchangedContentTracker");
    private static final Key<Long> LAST_TS_KEY = Key.create((String)"LAST_TS_KEY");
    private static final FileAttribute LAST_TS_ATTR = new FileAttribute("LAST_TS_ATTR", 0, true);
    private static final FileAttribute ACQUIRED_CONTENT_ATTR = new FileAttribute("ACQUIRED_CONTENT_ATTR", 1, true);
    private static final Key<Boolean> VCS_INVALID_FILE_STATUS = Key.create((String)"VCS_INVALID_FILE_STATUS");

    public static void updateLastUnchangedContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker", "updateLastUnchangedContent"));
        }
        if (LastUnchangedContentTracker.isTouched(file)) {
            return;
        }
        Long lastTs = LastUnchangedContentTracker.getLastSavedStamp(file);
        long stamp = file.getTimeStamp();
        if (lastTs != null && stamp == lastTs) {
            return;
        }
        Integer oldContentId = LastUnchangedContentTracker.getSavedContentId(file);
        if (oldContentId != null && oldContentId > 0) {
            LastUnchangedContentTracker.getFS().releaseContent(oldContentId);
        }
        LastUnchangedContentTracker.saveContentReference(file, LastUnchangedContentTracker.getFS().acquireContent(file));
        LastUnchangedContentTracker.markTouched(file);
    }

    private static boolean isTouched(VirtualFile file) {
        return Boolean.TRUE.equals(file.getUserData(VCS_INVALID_FILE_STATUS));
    }

    public static void markTouched(VirtualFile file) {
        file.putUserData(VCS_INVALID_FILE_STATUS, (Object)Boolean.TRUE);
    }

    public static void markUntouched(VirtualFile file) {
        file.putUserData(VCS_INVALID_FILE_STATUS, null);
    }

    @Nullable
    public static byte[] getLastUnchangedContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker", "getLastUnchangedContent"));
        }
        Integer id = LastUnchangedContentTracker.getSavedContentId(file);
        try {
            return id == null ? null : LastUnchangedContentTracker.getFS().contentsToByteArray(id);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private static PersistentFS getFS() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveContentReference(VirtualFile file, int contentId) {
        if (contentId == 0) {
            return;
        }
        LOG.assertTrue(contentId > 0, (Object)contentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveContentReference file = " + file);
        }
        long stamp = file.getTimeStamp();
        try {
            DataOutputStream contentStream = ACQUIRED_CONTENT_ATTR.writeAttribute(file);
            try {
                contentStream.writeInt(contentId);
            }
            finally {
                contentStream.close();
            }
            DataOutputStream tsStream = LAST_TS_ATTR.writeAttribute(file);
            try {
                tsStream.writeLong(stamp);
            }
            finally {
                tsStream.close();
            }
            file.putUserData(LAST_TS_KEY, (Object)stamp);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static boolean hasSavedContent(VirtualFile file) {
        return LastUnchangedContentTracker.getSavedContentId(file) != null;
    }

    public static void forceSavedContent(VirtualFile file, @NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker", "forceSavedContent"));
        }
        LastUnchangedContentTracker.saveContentReference(file, LastUnchangedContentTracker.getFS().storeUnlinkedContent(content.getBytes(file.getCharset())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Integer getSavedContentId(VirtualFile file) {
        Integer oldContentId;
        block6: {
            if (!file.isValid()) {
                return null;
            }
            oldContentId = null;
            try {
                DataInputStream stream = ACQUIRED_CONTENT_ATTR.readAttribute(file);
                if (stream == null) break block6;
                try {
                    oldContentId = stream.readInt();
                }
                finally {
                    stream.close();
                }
                LOG.assertTrue(oldContentId > 0, (Object)oldContentId);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return oldContentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Long getLastSavedStamp(VirtualFile file) {
        Long l;
        block6: {
            l = (Long)file.getUserData(LAST_TS_KEY);
            if (l == null) {
                try {
                    DataInputStream stream = LAST_TS_ATTR.readAttribute(file);
                    if (stream == null) break block6;
                    try {
                        l = stream.readLong();
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return l;
    }
}

