/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import java.util.List;

public class ShowAnnotationColorsAction
extends ToggleAction {
    public static final String KEY = "vcs.show.colored.annotations";
    private final List<AnnotationFieldGutter> myGutters;
    private final EditorGutterComponentEx myGutter;

    public ShowAnnotationColorsAction(List<AnnotationFieldGutter> gutters, EditorGutterComponentEx gutter) {
        super("Colors");
        this.myGutters = gutters;
        this.myGutter = gutter;
    }

    public boolean isSelected(AnActionEvent e) {
        return ShowAnnotationColorsAction.isColorsEnabled();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        PropertiesComponent.getInstance().setValue(KEY, String.valueOf(state));
        for (AnnotationFieldGutter gutter : this.myGutters) {
            gutter.setShowBg(state);
        }
        this.myGutter.revalidateMarkup();
    }

    public static boolean isColorsEnabled() {
        return PropertiesComponent.getInstance().getBoolean(KEY, true);
    }
}

