/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.SwitchAnnotationSourceAction;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.HighlightAnnotationsActions;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationPresentation
implements TextAnnotationPresentation {
    private final HighlightAnnotationsActions myHighlighting;
    @Nullable
    private final AnnotationSourceSwitcher mySwitcher;
    private final ArrayList<AnAction> myActions;
    private SwitchAnnotationSourceAction mySwitchAction;
    private final List<LineNumberListener> myPopupLineNumberListeners;

    AnnotationPresentation(@NotNull HighlightAnnotationsActions highlighting, @Nullable AnnotationSourceSwitcher switcher, EditorGutterComponentEx gutter, List<AnnotationFieldGutter> gutters, AnAction ... actions) {
        List<AnAction> actionsList;
        if (highlighting == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/actions/AnnotationPresentation", "<init>"));
        }
        this.myPopupLineNumberListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myHighlighting = highlighting;
        this.mySwitcher = switcher;
        this.myActions = new ArrayList();
        this.myActions.add((AnAction)Separator.getInstance());
        if (actions != null && !(actionsList = Arrays.asList(actions)).isEmpty()) {
            this.myActions.addAll(actionsList);
            this.myActions.add((AnAction)new Separator());
        }
        this.myActions.addAll(this.myHighlighting.getList());
        if (this.mySwitcher != null) {
            this.mySwitchAction = new SwitchAnnotationSourceAction(this.mySwitcher, gutter);
            this.myActions.add(this.mySwitchAction);
        }
    }

    public void addLineNumberListener(LineNumberListener listener) {
        this.myPopupLineNumberListeners.add(listener);
    }

    @Override
    public EditorFontType getFontType(int line) {
        return this.myHighlighting.isLineBold(line) ? EditorFontType.BOLD : EditorFontType.PLAIN;
    }

    @Override
    public ColorKey getColor(int line) {
        if (this.mySwitcher == null) {
            return AnnotationSource.LOCAL.getColor();
        }
        return this.mySwitcher.getAnnotationSource(line).getColor();
    }

    @Override
    public List<AnAction> getActions(int line) {
        for (LineNumberListener listener : this.myPopupLineNumberListeners) {
            listener.consume((Object)line);
        }
        return this.myActions;
    }

    @NotNull
    public List<AnAction> getActions() {
        ArrayList<AnAction> arrayList = this.myActions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotationPresentation", "getActions"));
        }
        return arrayList;
    }

    public void addSourceSwitchListener(Consumer<AnnotationSource> listener) {
        this.mySwitchAction.addSourceSwitchListener(listener);
    }

    public void addAction(AnAction action) {
        this.myActions.add(action);
    }

    public void addAction(AnAction action, int index) {
        this.myActions.add(index, action);
    }
}

