/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;

public class CommitCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        DataContext dataContext;
        PsiFile file = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document != null && (dataContext = (DataContext)document.getUserData(CommitMessage.DATA_CONTEXT_KEY)) != null) {
            ChangeList[] lists;
            result.stopHere();
            if (parameters.getInvocationCount() > 0 && (lists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(dataContext)) != null) {
                String prefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix(parameters);
                CompletionResultSet insensitive = result.caseInsensitive().withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
                for (ChangeList list : lists) {
                    for (Change change : list.getChanges()) {
                        ContentRevision revision = change.getAfterRevision() == null ? change.getBeforeRevision() : change.getAfterRevision();
                        if (revision == null) continue;
                        FilePath filePath = revision.getFile();
                        LookupElementBuilder element = LookupElementBuilder.create((String)filePath.getName()).withIcon(filePath.getFileType().getIcon());
                        insensitive.addElement((LookupElement)element);
                    }
                }
            }
        }
    }
}

