/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class UpdateInfoDialog
extends AbstractUpdateDialog {
    private final UpdateChannel myUpdatedChannel;
    private final BuildInfo myLatestBuild;
    private final PatchInfo myPatch;
    private final boolean myWriteProtected;

    protected UpdateInfoDialog(@NotNull UpdateChannel channel, boolean enableLink) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog", "<init>"));
        }
        super(enableLink);
        this.myUpdatedChannel = channel;
        this.myLatestBuild = channel.getLatestBuild();
        this.myPatch = this.myLatestBuild != null ? this.myLatestBuild.findPatchForCurrentBuild() : null;
        this.myWriteProtected = this.myPatch != null && !new File(PathManager.getHomePath()).canWrite();
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
        if (this.myLatestBuild != null) {
            this.initLicensingInfo(this.myUpdatedChannel, this.myLatestBuild);
        }
        this.init();
    }

    protected JComponent createCenterPanel() {
        return new UpdateInfoPanel().myPanel;
    }

    @NotNull
    protected Action[] createActions() {
        List<ButtonInfo> buttons;
        ArrayList actions = ContainerUtil.newArrayList();
        if (this.myPatch != null) {
            boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
            String button = IdeBundle.message((String)(canRestart ? "updates.download.and.restart.button" : "updates.download.and.install.button"), (Object[])new Object[0]);
            actions.add(new AbstractAction(button){
                {
                    this.setEnabled(!UpdateInfoDialog.this.myWriteProtected);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateInfoDialog.this.downloadPatch();
                }
            });
        }
        if ((buttons = this.myLatestBuild.getButtons()).isEmpty()) {
            actions.add(new AbstractAction(IdeBundle.message((String)"updates.more.info.button", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateInfoDialog.this.openDownloadPage();
                }
            });
        } else {
            for (ButtonInfo info : buttons) {
                if (info.isDownload() && this.myPatch != null) continue;
                actions.add(new ButtonAction(info));
            }
        }
        actions.add(new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String build = UpdateInfoDialog.this.myLatestBuild.getNumber().asStringWithoutProductCode();
                UpdateSettings.getInstance().getIgnoredBuildNumbers().add(build);
                UpdateInfoDialog.this.doCancelAction();
            }
        });
        actions.add(this.getCancelAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog", "createActions"));
        }
        return actionArray;
    }

    @Override
    protected String getCancelButtonText() {
        return IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
    }

    private void downloadPatch() {
        UpdateChecker.DownloadPatchResult result = UpdateChecker.downloadAndInstallPatch(this.myLatestBuild);
        if (result == UpdateChecker.DownloadPatchResult.SUCCESS) {
            this.restart();
        } else if (result == UpdateChecker.DownloadPatchResult.FAILED) {
            this.openDownloadPage();
        }
    }

    private void openDownloadPage() {
        BrowserUtil.browse((String)this.myUpdatedChannel.getHomePageUrl());
    }

    private class UpdateInfoPanel {
        private JPanel myPanel;
        private JEditorPane myUpdateMessage;
        private JBLabel myCurrentVersion;
        private JBLabel myNewVersion;
        private JBLabel myPatchLabel;
        private JBLabel myPatchInfo;
        private JEditorPane myMessageArea;
        private JEditorPane myLicenseArea;

        public UpdateInfoPanel() {
            this.$$$setupUI$$$();
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            ApplicationNamesInfo appNames = ApplicationNamesInfo.getInstance();
            String message = UpdateInfoDialog.this.myLatestBuild.getMessage();
            if (message == null) {
                message = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{appNames.getFullProductName()});
            }
            UpdateInfoDialog.this.configureMessageArea(this.myUpdateMessage, message, null, (HyperlinkListener)new BrowserHyperlinkListener());
            this.myCurrentVersion.setText(this.formatVersion(appInfo.getFullVersion(), appInfo.getBuild().asStringWithoutProductCode()));
            this.myNewVersion.setText(this.formatVersion(UpdateInfoDialog.this.myLatestBuild.getVersion(), UpdateInfoDialog.this.myLatestBuild.getNumber().asStringWithoutProductCode()));
            if (UpdateInfoDialog.this.myPatch != null) {
                this.myPatchInfo.setText(UpdateInfoDialog.this.myPatch.getSize() + " MB");
            } else {
                this.myPatchLabel.setVisible(false);
                this.myPatchInfo.setVisible(false);
            }
            if (UpdateInfoDialog.this.myWriteProtected) {
                message = IdeBundle.message((String)"updates.write.protected", (Object[])new Object[]{appNames.getProductName(), PathManager.getHomePath()});
                UpdateInfoDialog.this.configureMessageArea(this.myMessageArea, message, (Color)JBColor.RED, null);
            } else {
                UpdateInfoDialog.this.configureMessageArea(this.myMessageArea);
            }
            if (UpdateInfoDialog.this.mySubscribtionLicense && UpdateInfoDialog.this.myLicenseInfo != null) {
                UpdateInfoDialog.this.configureMessageArea(this.myLicenseArea, UpdateInfoDialog.this.myLicenseInfo, (Color)(UpdateInfoDialog.this.myPaidUpgrade ? JBColor.RED : null), null);
            }
        }

        private String formatVersion(String version, String build) {
            String[] parts = version.split("\\.", 3);
            String major = parts.length > 0 ? parts[0] : "0";
            String minor = parts.length > 1 ? parts[1] : "0";
            String patch = parts.length > 2 ? parts[2] : "0";
            version = major + '.' + minor + '.' + patch;
            return IdeBundle.message((String)"updates.version.info", (Object[])new Object[]{version, build});
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JEditorPane jEditorPane;
            JEditorPane jEditorPane2;
            JBLabel jBLabel;
            JBLabel jBLabel2;
            JBLabel jBLabel3;
            JBLabel jBLabel4;
            JEditorPane jEditorPane3;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), null, 0, 0, null, null));
            this.myUpdateMessage = jEditorPane3 = new JEditorPane();
            jEditorPane3.setMargin(new Insets(0, 0, 0, 0));
            jEditorPane3.setContentType("text/html");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jEditorPane3, gridBagConstraints);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(10, 0, 10, 0), -1, -1, false, false));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
            jPanel.add((Component)jPanel2, gridBagConstraints2);
            JBLabel jBLabel5 = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.current.version"));
            jPanel2.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myCurrentVersion = jBLabel4 = new JBLabel();
            jBLabel4.setText("X.Y (build XXX.YYY)");
            jPanel2.add((Component)jBLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            JBLabel jBLabel6 = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.available.version"));
            jPanel2.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNewVersion = jBLabel3 = new JBLabel();
            jBLabel3.setText("X.Y (build XXX.YYY)");
            jPanel2.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatchLabel = jBLabel2 = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.patch.label"));
            jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatchInfo = jBLabel = new JBLabel();
            jBLabel.setText("XX MB");
            jPanel2.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myMessageArea = jEditorPane2 = new JEditorPane();
            jEditorPane2.setContentType("text/html");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.fill = 1;
            jPanel.add((Component)jEditorPane2, gridBagConstraints3);
            JPanel jPanel3 = new JPanel();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 5;
            gridBagConstraints4.fill = 3;
            jPanel.add((Component)jPanel3, gridBagConstraints4);
            JPanel jPanel4 = new JPanel();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.fill = 3;
            gridBagConstraints5.insets = new Insets(5, 0, 0, 0);
            jPanel.add((Component)jPanel4, gridBagConstraints5);
            this.myLicenseArea = jEditorPane = new JEditorPane();
            jEditorPane.setOpaque(false);
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 4;
            gridBagConstraints6.fill = 1;
            jPanel.add((Component)jEditorPane, gridBagConstraints6);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class ButtonAction
    extends AbstractAction {
        private final String myUrl;

        private ButtonAction(ButtonInfo info) {
            super(info.getName());
            this.myUrl = info.getUrl();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserUtil.browse((String)this.myUrl);
        }
    }
}

