/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.util;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class WindowSystemPlaybackCall {
    public static AsyncResult<String> printFocus(PlaybackContext context) {
        final AsyncResult result = new AsyncResult();
        WindowSystemPlaybackCall.getUiReady(context).doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                LinkedHashMap focusInfo = WindowSystemPlaybackCall.getFocusInfo();
                if (focusInfo == null) {
                    result.setRejected((Object)"No component focused");
                    return;
                }
                StringBuffer text = new StringBuffer();
                Iterator iterator = focusInfo.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    text.append(key + "=" + (String)focusInfo.get(key));
                    if (!iterator.hasNext()) continue;
                    text.append("|");
                }
                result.setDone((Object)text.toString());
            }
        });
        return result;
    }

    public static AsyncResult<String> waitForDialog(final PlaybackContext context, final String title) {
        final AsyncResult result = new AsyncResult();
        final Ref listener = new Ref();
        listener.set((Object)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Window wnd;
                if (event.getID() == 205 && (wnd = ((WindowEvent)event).getWindow()) instanceof JDialog && title.equals(((JDialog)wnd).getTitle())) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener((AWTEventListener)listener.get());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowSystemPlaybackCall.getUiReady(context).notify((ActionCallback)result);
                        }
                    });
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener((AWTEventListener)listener.get(), 64L);
        SimpleTimer.getInstance().setUp(new Runnable(){

            @Override
            public void run() {
                Toolkit.getDefaultToolkit().removeAWTEventListener((AWTEventListener)listener.get());
                if (!result.isProcessed()) {
                    result.setRejected((Object)("Timed out waiting for window: " + title));
                }
            }
        }, (long)Registry.intValue((String)"actionSystem.commandProcessingTimeout"));
        return result;
    }

    public static AsyncResult<String> checkFocus(final PlaybackContext context, String expected) {
        final AsyncResult result = new AsyncResult();
        final LinkedHashMap<String, String> expectedMap = new LinkedHashMap<String, String>();
        if (expected.length() > 0) {
            String[] keyValue;
            for (String each : keyValue = expected.split("\\|")) {
                String[] eachPair = each.split("=");
                if (eachPair.length != 2) {
                    result.setRejected((Object)"Syntax error, must be |-separated pairs key=value");
                    return result;
                }
                expectedMap.put(eachPair[0], eachPair[1]);
            }
        }
        WindowSystemPlaybackCall.getUiReady(context).doWhenDone(new Runnable(){

            @Override
            public void run() {
                try {
                    WindowSystemPlaybackCall.doAssert(expectedMap, (AsyncResult<String>)result, context);
                }
                catch (AssertionError error) {
                    result.setRejected((Object)("Assertion failed: " + ((Throwable)((Object)error)).getMessage()));
                }
            }
        });
        return result;
    }

    public static AsyncResult<String> waitForToolWindow(final PlaybackContext context, final String id) {
        final AsyncResult result = new AsyncResult();
        WindowSystemPlaybackCall.findProject().doWhenDone((Consumer)new Consumer<Project>(){

            public void consume(Project project) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(id);
                if (toolWindow == null) {
                    result.setRejected((Object)("Cannot find tool window with id: " + id));
                    return;
                }
                toolWindow.getReady((Object)context).doWhenDone(result.createSetDoneRunnable()).doWhenRejected(new Runnable(){

                    @Override
                    public void run() {
                        result.setRejected((Object)("Cannot activate tool window with id:" + id));
                    }
                });
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                result.setRejected((Object)"Cannot retrieve open project");
            }
        });
        return result;
    }

    public static AsyncResult<Project> findProject() {
        final AsyncResult project = new AsyncResult();
        final IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                IdeFrame frame;
                Component parent = UIUtil.findUltimateParent((Component)fm.getFocusOwner());
                if (parent instanceof IdeFrame && (frame = (IdeFrame)parent).getProject() != null) {
                    project.setDone((Object)frame.getProject());
                    return;
                }
                project.setRejected();
            }
        });
        return project;
    }

    public static AsyncResult<String> contextMenu(final PlaybackContext context, final String path) {
        final AsyncResult result = new AsyncResult();
        final IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                Component owner = fm.getFocusOwner();
                if (owner == null) {
                    result.setRejected((Object)"No component focused");
                    return;
                }
                ActionManager am = ActionManager.getInstance();
                AnAction showPopupMenu = am.getAction("ShowPopupMenu");
                if (showPopupMenu == null) {
                    result.setRejected((Object)"Cannot find action: ShowPopupMenu");
                    return;
                }
                am.tryToExecute(showPopupMenu, (InputEvent)new MouseEvent(owner, 501, System.currentTimeMillis(), 0, 0, 0, 1, true), null, null, false).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
                                if (selectedPath.length == 0) {
                                    result.setRejected((Object)"Failed to find active popup menu");
                                    return;
                                }
                                WindowSystemPlaybackCall.selectNext(context, path.split("\\|"), 0, selectedPath[0].getSubElements(), (AsyncResult<String>)result);
                            }
                        });
                    }
                }).doWhenRejected(new Runnable(){

                    @Override
                    public void run() {
                        result.setRejected((Object)"Cannot invoke popup menu from the ShowPopupMenu action, action call rejected");
                    }
                });
            }
        });
        return result;
    }

    private static void selectNext(final PlaybackContext context, final String[] toSelect, final int toSelectIndex, MenuElement[] menuElements, final AsyncResult<String> result) {
        if (menuElements == null || menuElements.length == 0) {
            result.setDone();
        }
        if (toSelectIndex > toSelect.length - 1) {
            result.setDone();
            return;
        }
        String target = toSelect[toSelectIndex];
        for (MenuElement each : menuElements) {
            if (each.getComponent() instanceof AbstractButton) {
                final AbstractButton eachButton = (AbstractButton)each.getComponent();
                if (eachButton.getText() == null || !eachButton.getText().startsWith(target)) continue;
                WindowSystemPlaybackCall.activateItem(context, each).doWhenDone((Consumer)new Consumer<MenuElement[]>(){

                    public void consume(MenuElement[] menuElements) {
                        WindowSystemPlaybackCall.selectNext(context, toSelect, toSelectIndex + 1, menuElements, (AsyncResult<String>)result);
                    }
                }).doWhenRejected(new Runnable(){

                    @Override
                    public void run() {
                        result.setRejected((Object)("Cannot activate menu element: " + eachButton.getText()));
                    }
                });
                return;
            }
            result.setRejected((Object)("Unknown class for context menu item: " + each.getComponent()));
            return;
        }
        result.setRejected((Object)("Failed to find menu item: " + target));
    }

    private static AsyncResult<MenuElement[]> activateItem(final PlaybackContext context, final MenuElement element) {
        final AsyncResult result = new AsyncResult();
        final AbstractButton c = (AbstractButton)element.getComponent();
        final Runnable pressRunnable = new Runnable(){

            @Override
            public void run() {
                Robot robot = context.getRobot();
                Point location = c.getLocationOnScreen();
                Dimension size = c.getSize();
                Point point = new Point(location.x + size.width / 2, location.y + size.height / 2);
                robot.mouseMove(point.x, point.y);
                robot.delay(90);
                robot.mousePress(16);
                robot.delay(90);
                robot.mouseRelease(16);
                robot.delay(90);
                context.flushAwtAndRunInEdt(new Runnable(){

                    @Override
                    public void run() {
                        context.flushAwtAndRunInEdt(new Runnable(){

                            @Override
                            public void run() {
                                MenuElement[] subElements = element.getSubElements();
                                if (subElements == null || subElements.length == 0) {
                                    result.setDone();
                                } else {
                                    MenuElement[] menuElements = subElements[0].getSubElements();
                                    result.setDone((Object)menuElements);
                                }
                            }
                        });
                    }
                });
            }
        };
        if (c.isShowing()) {
            context.runPooledThread(pressRunnable);
        } else {
            context.delayAndRunInEdt(new Runnable(){

                @Override
                public void run() {
                    if (c.isShowing()) {
                        context.runPooledThread(pressRunnable);
                    } else {
                        result.setRejected();
                    }
                }
            }, 1000L);
        }
        return result;
    }

    public static ActionCallback getUiReady(final PlaybackContext context) {
        final ActionCallback result = new ActionCallback();
        context.flushAwtAndRunInEdt(new Runnable(){

            @Override
            public void run() {
                UiActivityMonitor.getInstance().getBusy(new UiActivity[0]).getReady((Object)context).notify(result);
            }
        });
        return result;
    }

    private static void doAssert(Map<String, String> expected, AsyncResult<String> result, PlaybackContext context) throws AssertionError {
        LinkedHashMap<String, String> actual = WindowSystemPlaybackCall.getFocusInfo();
        if (actual == null) {
            result.setRejected((Object)"No component focused");
            return;
        }
        LinkedHashSet<String> testedKeys = new LinkedHashSet<String>();
        for (String eachKey : expected.keySet()) {
            testedKeys.add(eachKey);
            String actualValue = actual.get(eachKey);
            String expectedValue = expected.get(eachKey);
            if (expectedValue.equals(actualValue)) continue;
            result.setRejected((Object)(eachKey + " expected: " + expectedValue + " but was: " + actualValue));
            return;
        }
        HashMap<String, String> untested = new HashMap<String, String>();
        for (String eachKey : actual.keySet()) {
            if (testedKeys.contains(eachKey)) continue;
            untested.put(eachKey, actual.get(eachKey));
        }
        StringBuffer untestedText = new StringBuffer();
        for (String each : untested.keySet()) {
            if (untestedText.length() > 0) {
                untestedText.append(",");
            }
            untestedText.append(each).append("=").append((String)untested.get(each));
        }
        result.setDone();
        if (untestedText.length() > 0) {
            context.message("Untested focus info: " + untestedText.toString(), context.getCurrentLine());
        }
    }

    private static LinkedHashMap<String, String> getFocusInfo() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return null;
        }
        LinkedHashMap<String, String> actual = new LinkedHashMap<String, String>();
        for (Component eachParent = owner; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof Queryable)) continue;
            ((Queryable)eachParent).putInfo(actual);
        }
        return actual;
    }

    public static AsyncResult<String> flushUi(PlaybackContext context) {
        AsyncResult result = new AsyncResult();
        WindowSystemPlaybackCall.getUiReady(context).notify((ActionCallback)result);
        return result;
    }
}

