/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class AssertFocused
extends AbstractCommand {
    public static final String PREFIX = "%assert focused";

    public AssertFocused(String text, int line) {
        super(text, line);
    }

    @Override
    protected ActionCallback _execute(final PlaybackContext context) {
        final ActionCallback result = new ActionCallback();
        String text = this.getText().substring(PREFIX.length()).trim();
        final LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        if (text.length() > 0) {
            String[] keyValue;
            for (String each : keyValue = text.split(",")) {
                String[] eachPair = each.split("=");
                if (eachPair.length != 2) {
                    context.error("Syntax error, must be comma-separated pairs key=value", this.getLine());
                    result.setRejected();
                    return result;
                }
                expected.put(eachPair[0], eachPair[1]);
            }
        }
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                try {
                    AssertFocused.this.doAssert(expected, context);
                    result.setDone();
                }
                catch (AssertionError error) {
                    context.error("Assertion failed: " + ((Throwable)((Object)error)).getMessage(), AssertFocused.this.getLine());
                    result.setRejected();
                }
            }
        });
        return result;
    }

    private void doAssert(Map<String, String> expected, PlaybackContext context) throws AssertionError {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            throw new AssertionError((Object)"No component focused");
        }
        LinkedHashMap actual = new LinkedHashMap();
        for (Component eachParent = owner; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof Queryable)) continue;
            ((Queryable)eachParent).putInfo(actual);
        }
        LinkedHashSet<String> testedKeys = new LinkedHashSet<String>();
        for (String eachKey : expected.keySet()) {
            testedKeys.add(eachKey);
            String actualValue = (String)actual.get(eachKey);
            String expectedValue = expected.get(eachKey);
            if (!expectedValue.equals(actualValue)) {
                throw new AssertionError((Object)(eachKey + " expected: " + expectedValue + " but was: " + actualValue));
            }
        }
        HashMap untested = new HashMap();
        for (String eachKey : actual.keySet()) {
            if (testedKeys.contains(eachKey)) continue;
            untested.put(eachKey, actual.get(eachKey));
        }
        StringBuffer untestedText = new StringBuffer();
        for (String each : untested.keySet()) {
            if (untestedText.length() > 0) {
                untestedText.append(",");
            }
            untestedText.append(each).append("=").append((String)untested.get(each));
        }
        context.message("Untested info: " + untestedText.toString(), this.getLine());
    }
}

