/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import java.io.File;

public abstract class AbstractCommand
implements PlaybackCommand {
    public static final String CMD_PREFIX = "%";
    private final String myText;
    private final int myLine;
    private File myScriptDir;

    public AbstractCommand(String text, int line) {
        this.myText = text != null ? text : null;
        this.myLine = line;
    }

    public String getText() {
        return this.myText;
    }

    public int getLine() {
        return this.myLine;
    }

    @Override
    public boolean canGoFurther() {
        return true;
    }

    @Override
    public final ActionCallback execute(final PlaybackContext context) {
        try {
            if (this.isToDumpCommand()) {
                this.dumpCommand(context);
            }
            final ActionCallback result = new ActionCallback();
            if (this.isAwtThread()) {
                this._execute(context).notify(result);
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractCommand.this._execute(context).notify(result);
                    }
                });
            }
            return result;
        }
        catch (Exception e) {
            context.error(e.getMessage(), this.getLine());
            return new ActionCallback.Rejected();
        }
    }

    protected boolean isToDumpCommand() {
        return true;
    }

    protected boolean isAwtThread() {
        return false;
    }

    protected abstract ActionCallback _execute(PlaybackContext var1);

    public void dumpCommand(PlaybackContext context) {
        context.code(this.getText(), this.getLine());
    }

    public void dumpError(PlaybackContext context, String text) {
        context.error(text, this.getLine());
    }

    @Override
    public File getScriptDir() {
        return this.myScriptDir;
    }

    public PlaybackCommand setScriptDir(File scriptDir) {
        this.myScriptDir = scriptDir;
        return this;
    }
}

