/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorDialogBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditExistingLibraryDialog
extends LibraryEditorDialogBase {
    private ExistingLibraryEditor myLibraryEditor;
    private boolean myCommitChanges;
    private LibraryTable.ModifiableModel myTableModifiableModel;

    public static EditExistingLibraryDialog createDialog(Component parent, LibraryTableModifiableModelProvider modelProvider, Library library, @Nullable Project project, LibraryTablePresentation presentation, StructureConfigurableContext context) {
        ExistingLibraryEditor libraryEditor;
        LibraryTable.ModifiableModel modifiableModel = modelProvider.getModifiableModel();
        boolean commitChanges = false;
        if (modifiableModel instanceof LibrariesModifiableModel) {
            libraryEditor = ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(library);
        } else {
            libraryEditor = new ExistingLibraryEditor(library, context);
            commitChanges = true;
        }
        return new EditExistingLibraryDialog(parent, modifiableModel, project, libraryEditor, commitChanges, presentation, context);
    }

    private EditExistingLibraryDialog(Component parent, LibraryTable.ModifiableModel tableModifiableModel, @Nullable Project project, ExistingLibraryEditor libraryEditor, boolean commitChanges, LibraryTablePresentation presentation, StructureConfigurableContext context) {
        super(parent, new LibraryRootsComponent(project, libraryEditor));
        this.setTitle("Configure " + presentation.getDisplayName(false));
        this.myTableModifiableModel = tableModifiableModel;
        this.myLibraryEditor = libraryEditor;
        this.myCommitChanges = commitChanges;
        if (commitChanges) {
            Disposer.register((Disposable)this.getDisposable(), (Disposable)libraryEditor);
        }
        context.addLibraryEditorListener(new LibraryEditorListener(){

            @Override
            public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
                if (library == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/EditExistingLibraryDialog$1", "libraryRenamed"));
                }
                if (library.equals(EditExistingLibraryDialog.this.myLibraryEditor.getLibrary())) {
                    EditExistingLibraryDialog.this.myNameField.setText(newName);
                }
            }
        }, this.getDisposable());
        this.init();
    }

    @Override
    protected boolean validateAndApply() {
        if (!super.validateAndApply()) {
            return false;
        }
        if (this.myCommitChanges) {
            this.myLibraryEditor.commit();
        }
        return true;
    }

    @Override
    protected LibraryTable.ModifiableModel getTableModifiableModel() {
        return this.myTableModifiableModel;
    }

    @Nullable
    protected String getHelpId() {
        return "Configure_Library_Dialog";
    }

    @Override
    protected boolean shouldCheckName(String newName) {
        return !Comparing.equal((String)newName, (String)this.getLibraryRootsComponent().getLibraryEditor().getName());
    }
}

