/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.FileTypeBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.PathUIUtils;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    @Override
    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor", "getRootTypePresentation"));
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type);
    }

    @Override
    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List<AttachUrlJavadocDescriptor> list = Arrays.asList(new AttachUrlJavadocDescriptor());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor", "createAttachButtons"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        List<RootDetector> list = Arrays.asList(new FileTypeBasedRootFilter(OrderRootType.CLASSES, false, StdFileTypes.CLASS, "classes"), new FileTypeBasedRootFilter(OrderRootType.CLASSES, true, StdFileTypes.CLASS, "jar directory"), PathUIUtils.JAVA_SOURCE_ROOT_DETECTOR, new FileTypeBasedRootFilter(OrderRootType.SOURCES, true, (FileType)StdFileTypes.JAVA, "source archive directory"), new JavadocRootDetector(), new AnnotationsRootFilter());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor", "getRootDetectors"));
        }
        return list;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType type) {
        OrderRootTypeUIFactory factory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type);
        return new OrderRootTypePresentation(factory.getNodeText(), factory.getIcon());
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlJavadocDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        @Override
        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$AttachUrlJavadocDescriptor", "selectFiles"));
            }
            if (libraryEditor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$AttachUrlJavadocDescriptor", "selectFiles"));
            }
            VirtualFile vFile = Util.showSpecifyJavadocUrlDialog(parent);
            if (vFile != null) {
                return new VirtualFile[]{vFile};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
    }

    private static class AnnotationsRootFilter
    extends FileTypeBasedRootFilter {
        private AnnotationsRootFilter() {
            super(AnnotationOrderRootType.getInstance(), false, (FileType)StdFileTypes.XML, "external annotations");
        }

        @Override
        protected boolean isFileAccepted(VirtualFile virtualFile) {
            return super.isFileAccepted(virtualFile) && virtualFile.getName().equals("annotations.xml");
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private JavadocRootDetector() {
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @Override
        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector", "detectRoots"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector", "detectRoots"));
            }
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            JavadocRootDetector.collectJavadocRoots(rootCandidate, result, progressIndicator);
            ArrayList<VirtualFile> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector", "detectRoots"));
            }
            return arrayList;
        }

        private static void collectJavadocRoots(VirtualFile file, final List<VirtualFile> result, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector$1", "visitFile"));
                    }
                    progressIndicator.checkCanceled();
                    if (file.isDirectory() && file.findChild("allclasses-frame.html") != null && file.findChild("allclasses-noframe.html") != null) {
                        result.add(file);
                        return false;
                    }
                    return true;
                }
            });
        }
    }
}

