/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.util.ui.ItemRemovable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ClasspathTableModel
extends AbstractTableModel
implements ItemRemovable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableModel");
    public static final String EXPORT_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.export.column", (Object[])new Object[0]);
    private static final String SCOPE_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.scope.column", (Object[])new Object[0]);
    public static final int EXPORT_COLUMN = 0;
    public static final int ITEM_COLUMN = 1;
    public static final int SCOPE_COLUMN = 2;
    private final List<ClasspathTableItem<?>> myItems = new ArrayList();
    private final ModuleConfigurationState myState;
    private StructureConfigurableContext myContext;

    public ClasspathTableModel(ModuleConfigurationState state, StructureConfigurableContext context) {
        this.myState = state;
        this.myContext = context;
        this.init();
    }

    private ModifiableRootModel getModel() {
        return this.myState.getRootModel();
    }

    public void init() {
        OrderEntry[] orderEntries = this.getModel().getOrderEntries();
        boolean hasJdkOrderEntry = false;
        for (OrderEntry orderEntry : orderEntries) {
            if (orderEntry instanceof JdkOrderEntry) {
                hasJdkOrderEntry = true;
            }
            this.addItem(ClasspathTableItem.createItem(orderEntry, this.myContext));
        }
        if (!hasJdkOrderEntry) {
            this.addItemAt(new InvalidJdkItem(), 0);
        }
    }

    public ClasspathTableItem<?> getItemAt(int row) {
        return this.myItems.get(row);
    }

    public void addItem(ClasspathTableItem<?> item) {
        this.myItems.add(item);
    }

    public void addItemAt(ClasspathTableItem<?> item, int row) {
        this.myItems.add(row, item);
    }

    public ClasspathTableItem<?> removeDataRow(int row) {
        return this.myItems.remove(row);
    }

    public void removeRow(int row) {
        this.removeDataRow(row);
    }

    public void clear() {
        this.myItems.clear();
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ClasspathTableItem<?> item = this.myItems.get(rowIndex);
        if (columnIndex == 0) {
            return item.isExported();
        }
        if (columnIndex == 2) {
            return item.getScope();
        }
        if (columnIndex == 1) {
            return item;
        }
        LOG.error("Incorrect column index: " + columnIndex);
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ClasspathTableItem<?> item = this.myItems.get(rowIndex);
        if (columnIndex == 0) {
            item.setExported((Boolean)aValue);
        } else if (columnIndex == 2 && aValue instanceof DependencyScope) {
            item.setScope((DependencyScope)aValue);
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return EXPORT_COLUMN_NAME;
        }
        if (column == 2) {
            return SCOPE_COLUMN_NAME;
        }
        return "";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return Boolean.class;
        }
        if (column == 2) {
            return DependencyScope.class;
        }
        if (column == 1) {
            return ClasspathTableItem.class;
        }
        return super.getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0 || column == 2) {
            ClasspathTableItem<?> item = this.myItems.get(row);
            return item != null && item.isExportable();
        }
        return false;
    }
}

