/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.classpath.LibraryItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import org.jetbrains.annotations.Nullable;

class ClasspathTableItem<T extends OrderEntry> {
    @Nullable
    protected final T myEntry;
    private final boolean myRemovable;

    @Nullable
    public static ClasspathTableItem<?> createItem(OrderEntry orderEntry, StructureConfigurableContext context) {
        if (orderEntry instanceof JdkOrderEntry) {
            return new ClasspathTableItem<OrderEntry>(orderEntry, false);
        }
        if (orderEntry instanceof LibraryOrderEntry) {
            return ClasspathTableItem.createLibItem((LibraryOrderEntry)orderEntry, context);
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            return new ClasspathTableItem<OrderEntry>(orderEntry, true);
        }
        if (orderEntry instanceof ModuleSourceOrderEntry) {
            return new ClasspathTableItem<OrderEntry>(orderEntry, false);
        }
        return null;
    }

    public static ClasspathTableItem<LibraryOrderEntry> createLibItem(LibraryOrderEntry orderEntry, StructureConfigurableContext context) {
        return new LibraryItem(orderEntry, context);
    }

    protected ClasspathTableItem(@Nullable T entry, boolean removable) {
        this.myEntry = entry;
        this.myRemovable = removable;
    }

    public final boolean isExportable() {
        return this.myEntry instanceof ExportableOrderEntry;
    }

    public final boolean isExported() {
        return this.myEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)this.myEntry).isExported();
    }

    public final void setExported(boolean isExported) {
        if (this.myEntry instanceof ExportableOrderEntry) {
            ((ExportableOrderEntry)this.myEntry).setExported(isExported);
        }
    }

    @Nullable
    public final DependencyScope getScope() {
        return this.myEntry instanceof ExportableOrderEntry ? ((ExportableOrderEntry)this.myEntry).getScope() : null;
    }

    public final void setScope(DependencyScope scope) {
        if (this.myEntry instanceof ExportableOrderEntry) {
            ((ExportableOrderEntry)this.myEntry).setScope(scope);
        }
    }

    @Nullable
    public final T getEntry() {
        return this.myEntry;
    }

    public boolean isRemovable() {
        return this.myRemovable;
    }

    public boolean isEditable() {
        return false;
    }

    @Nullable
    public String getTooltipText() {
        return null;
    }
}

