/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaSourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaSourceRootProperties> {
    public JavaSourceRootEditHandlerBase(JpsModuleSourceRootType<JavaSourceRootProperties> rootType) {
        super(rootType);
    }

    @Override
    @NotNull
    public Icon getRootIcon(@NotNull JavaSourceRootProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase", "getRootIcon"));
        }
        Icon icon = properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase", "getRootIcon"));
        }
        return icon;
    }

    @NotNull
    protected abstract Icon getGeneratedRootIcon();

    @Override
    @Nullable
    public String getPropertiesString(@NotNull JavaSourceRootProperties properties) {
        String packagePrefix;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase", "getPropertiesString"));
        }
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(packagePrefix = properties.getPackagePrefix()).isEmpty()) {
            buffer.append(" (").append(packagePrefix).append(")");
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    @Nullable
    public JComponent createPropertiesEditor(final @NotNull SourceFolder folder, final @NotNull JComponent parentComponent, final @NotNull ContentRootPanel.ActionCallback callback) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase", "createPropertiesEditor"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase", "createPropertiesEditor"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase", "createPropertiesEditor"));
        }
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.Modules.SetPackagePrefix, AllIcons.Modules.SetPackagePrefixRollover, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
                assert (properties != null);
                SourceRootPropertiesDialog dialog = new SourceRootPropertiesDialog(parentComponent, properties);
                dialog.show();
                if (dialog.isOK()) {
                    callback.onSourceRootPropertiesChanged(folder);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)iconComponent, "Center");
        panel.add(Box.createHorizontalStrut(3), "East");
        return panel;
    }

    private static class SourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myPackagePrefixField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaSourceRootProperties myProperties;

        private SourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaSourceRootProperties properties) {
            if (parentComponent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase$SourceRootPropertiesDialog", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase$SourceRootPropertiesDialog", "<init>"));
            }
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myPackagePrefixField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"For &generated sources"));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent("Package &prefix:", (JComponent)this.myPackagePrefixField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myPackagePrefixField.setText(this.myProperties.getPackagePrefix());
            this.myPackagePrefixField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPackagePrefixField;
        }

        protected void doOKAction() {
            this.myProperties.setPackagePrefix(this.myPackagePrefixField.getText().trim());
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }
    }
}

