/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.packaging.artifacts.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaProjectSettingsService
extends ProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;

    public IdeaProjectSettingsService(Project project) {
        this.myProject = project;
    }

    @Override
    public void openProjectSettings() {
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                config.selectProjectGeneralSettings(true);
            }
        });
    }

    @Override
    public void openGlobalLibraries() {
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                config.selectGlobalLibraries(true);
            }
        });
    }

    @Override
    public void openLibrary(final @NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/IdeaProjectSettingsService", "openLibrary"));
        }
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                config.selectProjectOrGlobalLibrary(library, true);
            }
        });
    }

    @Override
    public boolean canOpenModuleSettings() {
        return true;
    }

    @Override
    public void openModuleSettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), null);
    }

    @Override
    public boolean canOpenModuleLibrarySettings() {
        return true;
    }

    @Override
    public void openModuleLibrarySettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), ClasspathEditor.NAME);
    }

    @Override
    public boolean canOpenContentEntriesSettings() {
        return true;
    }

    @Override
    public void openContentEntriesSettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), ContentEntriesEditor.NAME);
    }

    @Override
    public boolean canOpenModuleDependenciesSettings() {
        return true;
    }

    @Override
    public void openModuleDependenciesSettings(final @NotNull Module module, final @Nullable OrderEntry orderEntry) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/IdeaProjectSettingsService", "openModuleDependenciesSettings"));
        }
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)ProjectStructureConfigurable.getInstance(this.myProject), new Runnable(){

            @Override
            public void run() {
                ProjectStructureConfigurable.getInstance(IdeaProjectSettingsService.this.myProject).selectOrderEntry(module, orderEntry);
            }
        });
    }

    @Override
    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return true;
    }

    @Override
    public void openLibraryOrSdkSettings(final @NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/IdeaProjectSettingsService", "openLibraryOrSdkSettings"));
        }
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                if (orderEntry instanceof JdkOrderEntry) {
                    config.select(((JdkOrderEntry)orderEntry).getJdk(), true);
                } else {
                    config.select((LibraryOrderEntry)orderEntry, true);
                }
            }
        });
    }

    @Override
    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        if (rootConfigurable.updateProjectTree(modules, targetGroup)) {
            if (targetGroup != null) {
                rootConfigurable.selectNodeInTree(targetGroup.toString());
            } else {
                rootConfigurable.selectNodeInTree(modules[0].getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        ModulesConfigurator.showDialog(this.myProject, moduleToSelect, editorNameToSelect);
    }

    @Override
    public Sdk chooseAndSetSdk() {
        return JdkChooserPanel.chooseAndSetJDK(this.myProject);
    }

    @Override
    public void openArtifactSettings(@Nullable Artifact artifact) {
        ModulesConfigurator.showArtifactSettings(this.myProject, artifact);
    }
}

