/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.TabbedModuleEditor;
import com.intellij.ui.navigation.Place;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeaderHidingTabbedModuleEditor
extends TabbedModuleEditor {
    public HeaderHidingTabbedModuleEditor(Project project, ModulesProvider modulesProvider, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/ui/configuration/HeaderHidingTabbedModuleEditor", "<init>"));
        }
        super(project, modulesProvider, module);
    }

    @Override
    protected JComponent createCenterPanel() {
        ModuleConfigurationEditor singleEditor = this.getSingleEditor();
        if (singleEditor != null) {
            JComponent component = singleEditor.createComponent();
            singleEditor.reset();
            return component;
        }
        return super.createCenterPanel();
    }

    @Nullable
    private ModuleConfigurationEditor getSingleEditor() {
        return this.myEditors.size() == 1 ? (ModuleConfigurationEditor)this.myEditors.get(0) : null;
    }

    @Override
    public ModuleConfigurationEditor getSelectedEditor() {
        ModuleConfigurationEditor singleEditor = this.getSingleEditor();
        return singleEditor != null ? singleEditor : super.getSelectedEditor();
    }

    @Override
    public void selectEditor(String displayName) {
        ModuleConfigurationEditor singleEditor;
        if (displayName != null && (singleEditor = this.getSingleEditor()) == null) {
            super.selectEditor(displayName);
        }
    }

    @Override
    protected void restoreSelectedEditor() {
        ModuleConfigurationEditor singleEditor = this.getSingleEditor();
        if (singleEditor == null) {
            super.restoreSelectedEditor();
        }
    }

    @Override
    @Nullable
    public ModuleConfigurationEditor getEditor(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/HeaderHidingTabbedModuleEditor", "getEditor"));
        }
        ModuleConfigurationEditor singleEditor = this.getSingleEditor();
        if (singleEditor != null) {
            if (displayName.equals(singleEditor.getDisplayName())) {
                return singleEditor;
            }
            return null;
        }
        return super.getEditor(displayName);
    }

    @Override
    protected void disposeCenterPanel() {
        if (this.getSingleEditor() == null) {
            super.disposeCenterPanel();
        }
    }

    @Override
    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/HeaderHidingTabbedModuleEditor", "queryPlace"));
        }
        ModuleConfigurationEditor singleEditor = this.getSingleEditor();
        if (singleEditor != null) {
            place.putPath("selectedEditor", (Object)singleEditor.getDisplayName());
        } else {
            super.queryPlace(place);
        }
    }
}

