/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.HttpUrlCellAppearance;
import com.intellij.openapi.roots.ui.util.JarSubfileCellAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.roots.ui.util.ValidFileCellAppearance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileAppearanceServiceImpl
extends FileAppearanceService {
    private static CellAppearanceEx EMPTY = new CellAppearanceEx(){

        public void customize(@NotNull SimpleColoredComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl$1", "customize"));
            }
        }

        public void customize(@NotNull HtmlListCellRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl$1", "customize"));
            }
        }

        @NotNull
        public String getText() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl$1", "getText"));
            }
            return "";
        }
    };

    @NotNull
    public CellAppearanceEx empty() {
        CellAppearanceEx cellAppearanceEx = EMPTY;
        if (cellAppearanceEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "empty"));
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forVirtualFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forVirtualFile"));
        }
        if (!file.isValid()) {
            CellAppearanceEx cellAppearanceEx = this.forInvalidUrl(file.getPresentableUrl());
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forVirtualFile"));
            }
            return cellAppearanceEx;
        }
        VirtualFileSystem fileSystem = file.getFileSystem();
        if (fileSystem.getProtocol().equals("jar")) {
            JarSubfileCellAppearance jarSubfileCellAppearance = new JarSubfileCellAppearance(file);
            if (jarSubfileCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forVirtualFile"));
            }
            return jarSubfileCellAppearance;
        }
        if (fileSystem instanceof HttpFileSystem) {
            HttpUrlCellAppearance httpUrlCellAppearance = new HttpUrlCellAppearance(file);
            if (httpUrlCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forVirtualFile"));
            }
            return httpUrlCellAppearance;
        }
        if (file.isDirectory()) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)file.getPresentableUrl(), (Icon)PlatformIcons.FOLDER_ICON);
            if (simpleTextCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forVirtualFile"));
            }
            return simpleTextCellAppearance;
        }
        ValidFileCellAppearance validFileCellAppearance = new ValidFileCellAppearance(file);
        if (validFileCellAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forVirtualFile"));
        }
        return validFileCellAppearance;
    }

    @NotNull
    public CellAppearanceEx forIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forIoFile"));
        }
        String absolutePath = file.getAbsolutePath();
        if (!file.exists()) {
            CellAppearanceEx cellAppearanceEx = this.forInvalidUrl(absolutePath);
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forIoFile"));
            }
            return cellAppearanceEx;
        }
        if (file.isDirectory()) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)absolutePath, (Icon)PlatformIcons.FOLDER_ICON);
            if (simpleTextCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forIoFile"));
            }
            return simpleTextCellAppearance;
        }
        String name = file.getName();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        File parent = file.getParentFile();
        CompositeAppearance appearance = CompositeAppearance.textComment((String)name, (String)parent.getAbsolutePath());
        appearance.setIcon(fileType.getIcon());
        CompositeAppearance compositeAppearance = appearance;
        if (compositeAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forIoFile"));
        }
        return compositeAppearance;
    }

    @NotNull
    public CellAppearanceEx forInvalidUrl(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forInvalidUrl"));
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.invalid((String)text, (Icon)PlatformIcons.INVALID_ENTRY_ICON);
        if (simpleTextCellAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl", "forInvalidUrl"));
        }
        return simpleTextCellAppearance;
    }
}

