/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class CheckboxTreeTable
extends TreeTableView {
    public CheckboxTreeTable(CheckedTreeNode root, CheckboxTree.CheckboxTreeCellRenderer renderer, ColumnInfo[] columns) {
        super(new ListTreeTableModelOnColumns((TreeNode)root, columns));
        this.initTree(this.getTree(), renderer);
    }

    private void initTree(final TreeTableTree tree, final CheckboxTree.CheckboxTreeCellRenderer cellRenderer) {
        tree.setCellRenderer((TreeCellRenderer)((Object)cellRenderer));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setLineStyleAngled();
        TreeUtil.installActions((JTree)tree);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/libraries/ui/impl/CheckboxTreeTable$1", "onClick"));
                }
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = tree.getPathForRow(row).getLastPathComponent();
                if (!(o instanceof CheckedTreeNode)) {
                    return false;
                }
                Rectangle rowBounds = tree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                CheckedTreeNode node = (CheckedTreeNode)o;
                if (checkBounds.contains(e.getPoint()) && node.isEnabled()) {
                    CheckboxTreeTable.this.toggleNode(node);
                    tree.setSelectionRow(row);
                    return true;
                }
                return false;
            }
        }.installOn((Component)((Object)this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (CheckboxTreeTable.isToggleEvent(e)) {
                    TreePath treePath = tree.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (!(o instanceof CheckedTreeNode)) {
                        return;
                    }
                    CheckedTreeNode firstNode = (CheckedTreeNode)o;
                    boolean checked = CheckboxTreeTable.this.toggleNode(firstNode);
                    TreePath[] selectionPaths = tree.getSelectionPaths();
                    for (int i = 0; selectionPaths != null && i < selectionPaths.length; ++i) {
                        TreePath selectionPath = selectionPaths[i];
                        Object o1 = selectionPath.getLastPathComponent();
                        if (!(o1 instanceof CheckedTreeNode)) continue;
                        CheckedTreeNode node = (CheckedTreeNode)o1;
                        CheckboxTreeTable.this.checkNode(node, checked);
                        ((DefaultTreeModel)tree.getModel()).nodeChanged((TreeNode)node);
                    }
                    e.consume();
                }
            }
        });
        tree.setSelectionRow(0);
    }

    private static boolean isToggleEvent(KeyEvent e) {
        return e.getKeyCode() == 32;
    }

    protected boolean toggleNode(CheckedTreeNode node) {
        boolean checked = !node.isChecked();
        this.checkNode(node, checked);
        TreeModel model = this.getTree().getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
        return checked;
    }

    private void checkNode(CheckedTreeNode node, boolean checked) {
        this.adjustParentsAndChildren(node, checked);
        this.repaint();
    }

    private void adjustParentsAndChildren(CheckedTreeNode node, boolean checked) {
        CheckboxTreeTable.changeNodeState(node, checked);
        if (!checked) {
            for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof CheckedTreeNode)) continue;
                CheckboxTreeTable.changeNodeState((CheckedTreeNode)parent, false);
            }
            CheckboxTreeTable.uncheckChildren(node);
        } else {
            CheckboxTreeTable.checkChildren(node);
        }
        this.repaint();
    }

    private static void changeNodeState(CheckedTreeNode node, boolean checked) {
        if (node.isChecked() != checked) {
            node.setChecked(checked);
        }
    }

    private static void uncheckChildren(CheckedTreeNode node) {
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            CheckboxTreeTable.changeNodeState(child, false);
            CheckboxTreeTable.uncheckChildren(child);
        }
    }

    private static void checkChildren(CheckedTreeNode node) {
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            CheckboxTreeTable.changeNodeState(child, true);
            CheckboxTreeTable.checkChildren(child);
        }
    }

    public <T> T[] getCheckedNodes(final Class<T> nodeType) {
        final ArrayList nodes = new ArrayList();
        Object root = this.getTree().getModel().getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            throw new IllegalStateException("The root must be instance of the " + CheckedTreeNode.class.getName() + ": " + root.getClass().getName());
        }
        new Object(){

            public void collect(CheckedTreeNode node) {
                if (node.isLeaf()) {
                    Object userObject = node.getUserObject();
                    if (node.isChecked() && userObject != null && nodeType.isAssignableFrom(userObject.getClass())) {
                        Object value = userObject;
                        nodes.add(value);
                    }
                } else {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        TreeNode child = node.getChildAt(i);
                        if (!(child instanceof CheckedTreeNode)) continue;
                        this.collect((CheckedTreeNode)child);
                    }
                }
            }
        }.collect((CheckedTreeNode)root);
        Object[] result = (Object[])Array.newInstance(nodeType, nodes.size());
        nodes.toArray(result);
        return result;
    }
}

