/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JarDirectoryWatcherImpl
implements JarDirectoryWatcher {
    private final JarDirectories myJarDirectories;
    private final RootProviderBaseImpl myRootProvider;
    private MessageBusConnection myBusConnection = null;
    private Collection<LocalFileSystem.WatchRequest> myWatchRequests = Collections.emptySet();

    public JarDirectoryWatcherImpl(JarDirectories jarDirectories, RootProviderBaseImpl rootProvider) {
        this.myJarDirectories = jarDirectories;
        this.myRootProvider = rootProvider;
    }

    @Override
    public void updateWatchedRoots() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!this.myJarDirectories.isEmpty()) {
            HashSet<String> recursiveRoots = new HashSet<String>();
            HashSet flatRoots = new HashSet();
            VirtualFileManager fm = VirtualFileManager.getInstance();
            for (OrderRootType rootType : this.myJarDirectories.getRootTypes()) {
                for (String url : this.myJarDirectories.getDirectories(rootType)) {
                    if (!(fm.getFileSystem(VirtualFileManager.extractProtocol((String)url)) instanceof LocalFileSystem)) continue;
                    boolean watchRecursively = this.myJarDirectories.isRecursive(rootType, url);
                    String path = VirtualFileManager.extractPath((String)url);
                    (watchRecursively ? recursiveRoots : flatRoots).add(path);
                }
            }
            this.myWatchRequests = fs.replaceWatchedRoots(this.myWatchRequests, recursiveRoots, flatRoots);
            if (this.myBusConnection == null) {
                this.myBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
                this.myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

                    public void after(@NotNull List<? extends VFileEvent> events) {
                        if (events == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/libraries/JarDirectoryWatcherImpl$1", "after"));
                        }
                        boolean changesDetected = false;
                        for (VFileEvent vFileEvent : events) {
                            VFileCreateEvent createEvent;
                            VirtualFile file;
                            if (vFileEvent instanceof VFileCopyEvent) {
                                VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                                file = copyEvent.getFile();
                                if (!this.isUnderJarDirectory(copyEvent.getNewParent() + "/" + copyEvent.getNewChildName()) && (file == null || !this.isUnderJarDirectory(file.getUrl()))) continue;
                                changesDetected = true;
                                break;
                            }
                            if (vFileEvent instanceof VFileMoveEvent) {
                                VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                                file = moveEvent.getFile();
                                if (file == null || !this.isUnderJarDirectory(file.getUrl()) && !this.isUnderJarDirectory(moveEvent.getOldParent().getUrl() + "/" + file.getName())) continue;
                                changesDetected = true;
                                break;
                            }
                            if (vFileEvent instanceof VFileDeleteEvent) {
                                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                                if (!this.isUnderJarDirectory(deleteEvent.getFile().getUrl())) continue;
                                changesDetected = true;
                                break;
                            }
                            if (!(vFileEvent instanceof VFileCreateEvent) || !this.isUnderJarDirectory((createEvent = (VFileCreateEvent)vFileEvent).getParent().getUrl() + "/" + createEvent.getChildName())) continue;
                            changesDetected = true;
                            break;
                        }
                        if (changesDetected) {
                            JarDirectoryWatcherImpl.this.fireRootSetChanged();
                        }
                    }

                    private boolean isUnderJarDirectory(String url) {
                        for (String string : JarDirectoryWatcherImpl.this.myJarDirectories.getAllDirectories()) {
                            if (!FileUtil.startsWith((String)url, (String)string)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        } else {
            this.cleanup();
        }
    }

    protected void fireRootSetChanged() {
        this.myRootProvider.fireRootSetChanged();
    }

    public void dispose() {
        this.cleanup();
    }

    private void cleanup() {
        MessageBusConnection connection;
        if (!this.myWatchRequests.isEmpty()) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
            this.myWatchRequests = Collections.emptySet();
        }
        if ((connection = this.myBusConnection) != null) {
            this.myBusConnection = null;
            connection.disconnect();
        }
    }
}

