/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;
    private final ContentFilter myContentFilter;

    public ProjectFileIndexImpl(@NotNull Project project, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        super(directoryIndex, fileTypeManager, project);
        this.myProject = project;
        this.myContentFilter = new ContentFilter();
    }

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        Module[] modules;
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContent"));
        }
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            VirtualFile[] contentRoots;
            if (module.isDisposed()) continue;
            for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                boolean finished;
                DirectoryInfo parentInfo;
                VirtualFile parent;
                DirectoryInfo info = this.getInfoForFileOrDirectory(contentRoot);
                if (info == null || !module.equals(info.getModule()) || (parent = contentRoot.getParent()) != null && (parentInfo = this.getInfoForFileOrDirectory(parent)) != null && parentInfo.getModule() != null || (finished = VfsUtilCore.iterateChildrenRecursively((VirtualFile)contentRoot, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContentUnderDirectory"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContentUnderDirectory"));
        }
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
    }

    public boolean isIgnored(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isIgnored"));
        }
        if (this.myFileTypeRegistry.isFileIgnored(file)) {
            return true;
        }
        if (this.myExclusionManager != null && this.myExclusionManager.isExcluded(file)) {
            return true;
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return false;
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(dir);
        if (info != null) {
            return false;
        }
        if (this.myDirectoryIndex.isProjectExcludeRoot(dir)) {
            return true;
        }
        VirtualFile parent = dir.getParent();
        while (parent != null) {
            DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(parent);
            if (parentInfo != null) {
                return true;
            }
            if (this.myDirectoryIndex.isProjectExcludeRoot(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public Module getModuleForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getModuleForFile"));
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return null;
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(dir);
        if (info == null) {
            return null;
        }
        return info.getModule();
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (info == null) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
            }
            return list;
        }
        List<OrderEntry> list = Arrays.asList(info.getOrderEntries());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
        }
        return list;
    }

    public VirtualFile getClassRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getClassRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (info == null) {
            return null;
        }
        return info.getLibraryClassRoot();
    }

    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getSourceRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (info == null) {
            return null;
        }
        return info.getSourceRoot();
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getContentRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (info == null) {
            return null;
        }
        return info.getContentRoot();
    }

    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getPackageNameByDirectory"));
        }
        LOG.assertTrue(dir.isDirectory());
        return this.myDirectoryIndex.getPackageName(dir);
    }

    public boolean isLibraryClassFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isLibraryClassFile"));
        }
        if (file.isDirectory()) {
            return false;
        }
        if (this.myFileTypeRegistry.isFileIgnored(file)) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file);
        return parentInfo != null && parentInfo.hasLibraryClassRoot();
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInSource"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && (info.isInModuleSource() || info.isInLibrarySource());
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibraryClasses"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.hasLibraryClassRoot();
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibrarySource"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInLibrarySource();
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.getModule() != null;
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInModuleSource();
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInTestSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInModuleSource() && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderSourceRootOfType"));
        }
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderSourceRootOfType"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInModuleSource() && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl$ContentFilter", "accept"));
            }
            if (file.isDirectory()) {
                DirectoryInfo info = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(file);
                return info != null && info.getModule() != null;
            }
            return (ProjectFileIndexImpl.this.myExclusionManager == null || !ProjectFileIndexImpl.this.myExclusionManager.isExcluded(file)) && !ProjectFileIndexImpl.this.myFileTypeRegistry.isFileIgnored(file);
        }
    }
}

