/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulesOrderEnumerator
extends OrderEnumeratorBase {
    private final Collection<? extends Module> myModules;

    public ModulesOrderEnumerator(@NotNull Project project, @NotNull Collection<? extends Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "<init>"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "<init>"));
        }
        super(null, project, null);
        this.myModules = modules;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "processRootModules"));
        }
        for (Module module : this.myModules) {
            processor.process((Object)module);
        }
    }

    public void forEach(@NotNull Processor<OrderEntry> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "forEach"));
        }
        this.myRecursivelyExportedOnly = false;
        THashSet processed = new THashSet();
        for (Module module : this.myModules) {
            this.processEntries(this.getRootModel(module), processor, (Set<Module>)processed, true);
        }
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "isRootModuleModel"));
        }
        return this.myModules.contains(rootModel.getModule());
    }
}

