/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    private final Module myModule;
    private final ContentFilter myContentFilter;

    public ModuleFileIndexImpl(Module module, DirectoryIndex directoryIndex) {
        super(directoryIndex, FileTypeRegistry.getInstance(), module.getProject());
        this.myModule = module;
        this.myContentFilter = new ContentFilter();
    }

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        VirtualFile[] contentRoots;
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "iterateContent"));
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()) {
            boolean finished;
            DirectoryInfo parentInfo;
            VirtualFile parent = contentRoot.getParent();
            if (parent != null && (parentInfo = this.myDirectoryIndex.getInfoForDirectory(parent)) != null && this.myModule.equals(parentInfo.getModule()) || (finished = VfsUtilCore.iterateChildrenRecursively((VirtualFile)contentRoot, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator))) continue;
            return false;
        }
        return true;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "iterateContentUnderDirectory"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "iterateContentUnderDirectory"));
        }
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isInContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && this.myModule.equals(info.getModule());
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isInSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInModuleSource() && this.myModule.equals(info.getModule());
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntriesForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        if (info == null) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntriesForFile"));
            }
            return list;
        }
        List<OrderEntry> list = info.findAllOrderEntriesWithOwnerModule(this.myModule);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntriesForFile"));
        }
        return list;
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntryForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        if (info == null) {
            return null;
        }
        return info.findOrderEntryWithOwnerModule(this.myModule);
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isInTestSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInModuleSource() && this.myModule.equals(info.getModule()) && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isUnderSourceRootOfType"));
        }
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isUnderSourceRootOfType"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info != null && info.isInModuleSource() && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$ContentFilter", "accept"));
            }
            if (file.isDirectory()) {
                DirectoryInfo info = ModuleFileIndexImpl.this.myDirectoryIndex.getInfoForDirectory(file);
                return info != null && ModuleFileIndexImpl.this.myModule.equals(info.getModule());
            }
            if (ModuleFileIndexImpl.this.myExclusionManager != null && ModuleFileIndexImpl.this.myExclusionManager.isExcluded(file)) {
                return false;
            }
            return !ModuleFileIndexImpl.this.myFileTypeRegistry.isFileIgnored(file);
        }
    }
}

