/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModifiableModelCommitter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModifiableModelCommitter");

    public static void multiCommit(ModifiableRootModel[] rootModels, ModifiableModuleModel moduleModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final List<RootModelImpl> modelsToCommit = ModifiableModelCommitter.getSortedChangedModels(rootModels, moduleModel);
        final ArrayList<ModifiableRootModel> modelsToDispose = new ArrayList<ModifiableRootModel>(Arrays.asList(rootModels));
        modelsToDispose.removeAll(modelsToCommit);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (RootModelImpl rootModel : modelsToCommit) {
                    ModifiableModelCommitter.commitModelWithoutEvents(rootModel);
                }
                for (ModifiableRootModel model : modelsToDispose) {
                    model.dispose();
                }
            }
        };
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, runnable);
    }

    private static void commitModelWithoutEvents(RootModelImpl rootModel) {
        ModuleRootManagerImpl.doCommit(rootModel);
    }

    private static List<RootModelImpl> getSortedChangedModels(ModifiableRootModel[] _rootModels, ModifiableModuleModel moduleModel) {
        ArrayList<RootModelImpl> rootModels = new ArrayList<RootModelImpl>();
        for (ModifiableRootModel _rootModel : _rootModels) {
            RootModelImpl rootModel = (RootModelImpl)_rootModel;
            if (!rootModel.isChanged()) continue;
            rootModels.add(rootModel);
        }
        ModifiableModelCommitter.sortRootModels(rootModels, moduleModel);
        return rootModels;
    }

    private static void sortRootModels(List<RootModelImpl> rootModels, ModifiableModuleModel moduleModel) {
        DFSTBuilder<RootModelImpl> builder = ModifiableModelCommitter.createDFSTBuilder(rootModels, moduleModel);
        Comparator comparator = builder.comparator();
        Collections.sort(rootModels, comparator);
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        HashMap nameToModel = new HashMap();
        for (RootModelImpl rootModel : rootModels) {
            String name = rootModel.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name), (Object)name);
            nameToModel.put(name, rootModel);
        }
        for (Module module : modules = moduleModel.getModules()) {
            String name = module.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).getRootModel();
            nameToModel.put(name, rootModel);
        }
        final Collection allRootModels = nameToModel.values();
        return new DFSTBuilder((Graph)new GraphGenerator((GraphGenerator.SemiGraph)new CachingSemiGraph((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<RootModelImpl>((Map)nameToModel){
            final /* synthetic */ Map val$nameToModel;
            {
                this.val$nameToModel = map;
            }

            public Collection<RootModelImpl> getNodes() {
                return allRootModels;
            }

            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                List namesList = (List)rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process((RootPolicy)new RootPolicy<ArrayList<String>>(){

                    public ArrayList<String> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, ArrayList<String> strings) {
                        Module module = moduleOrderEntry.getModule();
                        if (module != null && !module.isDisposed()) {
                            strings.add(module.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray((Collection)namesList);
                ArrayList<RootModelImpl> result = new ArrayList<RootModelImpl>();
                for (String name : names) {
                    RootModelImpl depRootModel = (RootModelImpl)this.val$nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result.add(depRootModel);
                }
                return result.iterator();
            }
        })));
    }
}

