/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SdkResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class LibraryScopeCache {
    private final Project myProject;
    private final ConcurrentMap<List<Module>, GlobalSearchScope> myLibraryScopes = new ConcurrentHashMap();
    private final ConcurrentMap<String, GlobalSearchScope> mySdkScopes = new ConcurrentHashMap();

    public static LibraryScopeCache getInstance(Project project) {
        return (LibraryScopeCache)ServiceManager.getService((Project)project, LibraryScopeCache.class);
    }

    public LibraryScopeCache(Project project) {
        this.myProject = project;
    }

    public void clear() {
        this.myLibraryScopes.clear();
        this.mySdkScopes.clear();
    }

    public GlobalSearchScope getScopeForLibraryUsedIn(List<Module> modulesLibraryIsUsedIn) {
        GlobalSearchScope scope = (GlobalSearchScope)this.myLibraryScopes.get(modulesLibraryIsUsedIn);
        if (scope != null) {
            return scope;
        }
        GlobalSearchScope newScope = modulesLibraryIsUsedIn.isEmpty() ? new LibrariesOnlyScope(GlobalSearchScope.allScope((Project)this.myProject)) : new LibraryRuntimeClasspathScope(this.myProject, modulesLibraryIsUsedIn);
        return (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.myLibraryScopes, modulesLibraryIsUsedIn, (Object)newScope);
    }

    public GlobalSearchScope getScopeForSdk(JdkOrderEntry jdkOrderEntry) {
        String jdkName = jdkOrderEntry.getJdkName();
        if (jdkName == null) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.mySdkScopes.get(jdkName);
        if (scope == null) {
            SdkResolveScopeProvider provider;
            SdkResolveScopeProvider[] arr$ = (SdkResolveScopeProvider[])SdkResolveScopeProvider.EP_NAME.getExtensions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (scope = (provider = arr$[i$]).getScope(this.myProject, jdkOrderEntry)) == null; ++i$) {
            }
            if (scope == null) {
                scope = new JdkScope(this.myProject, jdkOrderEntry);
            }
            return (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.mySdkScopes, (Object)jdkName, (Object)scope);
        }
        return scope;
    }

    private static class LibrariesOnlyScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myOriginal;

        private LibrariesOnlyScope(GlobalSearchScope original) {
            super(original.getProject());
            this.myOriginal = original;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "contains"));
            }
            return this.myOriginal.contains(file);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "compare"));
            }
            return this.myOriginal.compare(file1, file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

